/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.util.StringUtils;

public abstract class HtmlTableCell
extends HtmlElement {
    protected HtmlTableCell(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public int getColumnSpan() {
        String spanString = StringUtils.replaceChars(this.getAttributeDirect("colspan"), "\r\n\t ", null);
        if (spanString == null || spanString.isEmpty()) {
            return 1;
        }
        try {
            int span = (int)Double.parseDouble(spanString);
            if (span < 1) {
                return 1;
            }
            return Math.min(span, 1000);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public int getRowSpan() {
        String spanString = StringUtils.replaceChars(this.getAttributeDirect("rowspan"), "\r\n\t ", null);
        if (spanString == null || spanString.isEmpty()) {
            return 1;
        }
        try {
            int span = (int)Double.parseDouble(spanString);
            if (span < 0) {
                return 1;
            }
            if (span < 1) {
                return 0;
            }
            return Math.min(span, 65534);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public HtmlTableRow getEnclosingRow() {
        return (HtmlTableRow)this.getEnclosingElement("tr");
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.TABLE_CELL;
    }
}

