/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlSelectableTextInput;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.util.StringUtils;

public class HtmlDateInput
extends HtmlSelectableTextInput
implements LabelableElement {
    private static final DateTimeFormatter FORMATTER_ = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    HtmlDateInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    protected boolean isSubmittableByEnter() {
        return true;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void reset() {
        super.reset();
        this.setSelectionEnd(0);
    }

    @Override
    protected boolean isPatternSupported() {
        return true;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (!this.getMin().isEmpty()) {
            try {
                LocalDate dateValue = LocalDate.parse(this.getRawValue(), FORMATTER_);
                LocalDate minDate = LocalDate.parse(this.getMin(), FORMATTER_);
                return minDate.isEqual(dateValue) || minDate.isBefore(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (!this.getMax().isEmpty()) {
            try {
                LocalDate dateValue = LocalDate.parse(this.getRawValue(), FORMATTER_);
                LocalDate maxDate = LocalDate.parse(this.getMax(), FORMATTER_);
                return maxDate.isEqual(dateValue) || maxDate.isAfter(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void setValue(String newValue) {
        try {
            if (!StringUtils.isEmptyOrNull(newValue)) {
                FORMATTER_.parse(newValue);
            }
            super.setValue(newValue);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }
}

