/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.Serializable;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlDomTreeWalker;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class DomNodeIterator
implements NodeIterator,
Serializable {
    private final DomNode root_;
    private final int whatToShow_;
    private final NodeFilter filter_;
    private DomNode referenceNode_;
    private final boolean expandEntityReferences_;
    private boolean pointerBeforeReferenceNode_;

    public DomNodeIterator(DomNode root, int whatToShow, NodeFilter filter, boolean expandEntityReferences) {
        this.root_ = root;
        this.referenceNode_ = root;
        this.whatToShow_ = whatToShow;
        this.filter_ = filter;
        this.expandEntityReferences_ = expandEntityReferences;
        this.pointerBeforeReferenceNode_ = true;
    }

    @Override
    public DomNode getRoot() {
        return this.root_;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow_;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences_;
    }

    @Override
    public NodeFilter getFilter() {
        return this.filter_;
    }

    public boolean isPointerBeforeReferenceNode() {
        return this.pointerBeforeReferenceNode_;
    }

    @Override
    public void detach() {
    }

    @Override
    public DomNode nextNode() {
        return this.traverse(true);
    }

    @Override
    public DomNode previousNode() {
        return this.traverse(false);
    }

    private DomNode traverse(boolean next) {
        DomNode node = this.referenceNode_;
        boolean beforeNode = this.pointerBeforeReferenceNode_;
        do {
            if (next) {
                if (beforeNode) {
                    beforeNode = false;
                    continue;
                }
                DomNode leftChild = DomNodeIterator.getChild(node, true);
                if (leftChild == null) {
                    DomNode rightSibling = DomNodeIterator.getSibling(node, false);
                    if (rightSibling == null) {
                        node = this.getFirstUncleNode(node);
                        continue;
                    }
                    node = rightSibling;
                    continue;
                }
                node = leftChild;
                continue;
            }
            if (beforeNode) {
                DomNode follow = DomNodeIterator.getSibling(node, true);
                if (follow != null) {
                    DomNode toFollow;
                    while (follow.hasChildNodes() && (toFollow = DomNodeIterator.getChild(follow, false)) != null) {
                        follow = toFollow;
                    }
                }
                node = follow;
                continue;
            }
            beforeNode = true;
        } while (node != null && (!this.isNodeVisible(node) || !this.isAccepted(node)));
        this.referenceNode_ = node;
        this.pointerBeforeReferenceNode_ = beforeNode;
        return node;
    }

    private boolean isNodeVisible(Node node) {
        return (this.whatToShow_ & HtmlDomTreeWalker.getFlagForNode(node)) != 0;
    }

    private boolean isAccepted(Node node) {
        if (this.filter_ == null) {
            return true;
        }
        return this.filter_.acceptNode(node) == 1;
    }

    private DomNode getFirstUncleNode(DomNode node) {
        if (node == null || node == this.root_) {
            return null;
        }
        DomNode parent = node.getParentNode();
        if (parent == null || parent == this.root_) {
            return null;
        }
        DomNode uncle = DomNodeIterator.getSibling(parent, false);
        if (uncle != null) {
            return uncle;
        }
        return this.getFirstUncleNode(parent);
    }

    private static DomNode getChild(DomNode node, boolean lookLeft) {
        if (node == null) {
            return null;
        }
        DomNode child = lookLeft ? node.getFirstChild() : node.getLastChild();
        return child;
    }

    private static DomNode getSibling(DomNode node, boolean lookLeft) {
        if (node == null) {
            return null;
        }
        DomNode sibling = lookLeft ? node.getPreviousSibling() : node.getNextSibling();
        return sibling;
    }
}

