/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.html.dom;

import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.htmlunit.cyberneko.html.dom.HTMLAnchorElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLAppletElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLAreaElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLBRElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLBaseElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLBaseFontElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLBodyElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLButtonElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLCollectionImpl;
import org.htmlunit.cyberneko.html.dom.HTMLDListElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLDirectoryElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLDivElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLFieldSetElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLFontElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLFormElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLFrameElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLFrameSetElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLHRElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLHeadElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLHeadingElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLHtmlElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLIFrameElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLImageElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLInputElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLIsIndexElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLLIElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLLabelElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLLegendElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLLinkElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLMapElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLMenuElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLMetaElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLModElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLOListElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLObjectElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLOptGroupElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLOptionElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLParagraphElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLParamElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLPreElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLQuoteElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLScriptElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLSelectElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLStyleElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLTableCaptionElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLTableCellElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLTableColElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLTableElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLTableRowElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLTableSectionElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLTextAreaElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLTitleElementImpl;
import org.htmlunit.cyberneko.html.dom.HTMLUListElementImpl;
import org.htmlunit.cyberneko.html.dom.NameNodeListImpl;
import org.htmlunit.cyberneko.util.FastHashMap;
import org.htmlunit.cyberneko.xerces.dom.DocumentImpl;
import org.htmlunit.cyberneko.xerces.dom.ElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLFrameSetElement;
import org.w3c.dom.html.HTMLHeadElement;
import org.w3c.dom.html.HTMLHtmlElement;
import org.w3c.dom.html.HTMLTitleElement;

public class HTMLDocumentImpl
extends DocumentImpl
implements HTMLDocument {
    private static final String[] HTML5ELEMENTS = new String[]{"A", "ABBR", "ADDRESS", "AREA", "ARTICLE", "ASIDE", "AUDIO", "B", "BASE", "BDI", "BDO", "BLOCKQUOTE", "BODY", "BR", "BUTTON", "CANVAS", "CAPTION", "CITE", "CODE", "COL", "COLGROUP", "DATA", "DATALIST", "DD", "DEL", "DETAILS", "DFN", "DIALOG", "DIV", "DL", "DT", "EM", "EMBED", "FIELDSET", "FIGCAPTION", "FIGURE", "FOOTER", "FORM", "HEAD", "HEADER", "HGROUP", "H1", "HR", "HTML", "I", "IFRAME", "IMG", "INPUT", "INS", "KBD", "KEYGEN", "LABEL", "LEGEND", "LI", "LINK", "MAIN", "MAP", "MARK", "MENU", "MENUITEM", "META", "METER", "NAV", "NOSCRIPT", "OBJECT", "OL", "OPTGROUP", "OPTION", "OUTPUT", "P", "PARAM", "PICTURE", "PRE", "PROGRESS", "Q", "RP", "RT", "RUBY", "S", "SAMP", "SCRIPT", "SECTION", "SELECT", "SMALL", "SOURCE", "SPAN", "STRONG", "STYLE", "SUB", "SUMMARY", "SUP", "SVG", "TABLE", "TBODY", "TD", "TEMPLATE", "TEXTAREA", "TFOOT", "TH", "THEAD", "TIME", "TITLE", "TR", "TRACK", "U", "UL", "VAR", "VIDEO", "WBR"};
    private HTMLCollectionImpl anchors_;
    private HTMLCollectionImpl forms_;
    private HTMLCollectionImpl images_;
    private HTMLCollectionImpl links_;
    private HTMLCollectionImpl applets_;
    private StringWriter writer_;
    private static final FastHashMap<String, ElementTypesHTMLHolder> ELEMENT_TYPES_HTML_LOWER = new FastHashMap(11, 0.5f);
    private static final FastHashMap<String, ElementTypesHTMLHolder> ELEMENT_TYPES_HTML_UPPER = new FastHashMap(11, 0.5f);
    private static final Class<?>[] ELEMENT_CLASS_CTOR_SIGNATURE = new Class[]{HTMLDocumentImpl.class, String.class};

    @Override
    public synchronized Element getDocumentElement() {
        Node html;
        for (html = this.getFirstChild(); html != null; html = html.getNextSibling()) {
            if (!(html instanceof HTMLHtmlElement)) continue;
            return (HTMLElement)html;
        }
        html = new HTMLHtmlElementImpl(this, "HTML");
        Node child = this.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            html.appendChild(child);
            child = next;
        }
        this.appendChild(html);
        return (HTMLElement)html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HTMLElement getHead() {
        Node head;
        Element html;
        Element element = html = this.getDocumentElement();
        synchronized (element) {
            for (head = html.getFirstChild(); head != null && !(head instanceof HTMLHeadElement); head = head.getNextSibling()) {
            }
            if (head != null) {
                Node node = head;
                synchronized (node) {
                    Node child = html.getFirstChild();
                    while (child != null && child != head) {
                        Node next = child.getNextSibling();
                        head.insertBefore(child, head.getFirstChild());
                        child = next;
                    }
                }
                return (HTMLElement)head;
            }
            head = new HTMLHeadElementImpl(this, "HEAD");
            html.insertBefore(head, html.getFirstChild());
        }
        return (HTMLElement)head;
    }

    @Override
    public synchronized String getTitle() {
        HTMLElement head = this.getHead();
        NodeList list = head.getElementsByTagName("TITLE");
        if (list.getLength() > 0) {
            Node title = list.item(0);
            return ((HTMLTitleElement)title).getText();
        }
        return "";
    }

    @Override
    public synchronized void setTitle(String newTitle) {
        HTMLElement head = this.getHead();
        NodeList list = head.getElementsByTagName("TITLE");
        if (list.getLength() > 0) {
            Node title = list.item(0);
            if (title.getParentNode() != head) {
                head.appendChild(title);
            }
            ((HTMLTitleElement)title).setText(newTitle);
        } else {
            HTMLTitleElementImpl title = new HTMLTitleElementImpl(this, "TITLE");
            ((HTMLTitleElement)title).setText(newTitle);
            head.appendChild(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HTMLElement getBody() {
        Node body;
        Element html = this.getDocumentElement();
        HTMLElement head = this.getHead();
        Element element = html;
        synchronized (element) {
            for (body = head.getNextSibling(); body != null && !(body instanceof HTMLBodyElement) && !(body instanceof HTMLFrameSetElement); body = body.getNextSibling()) {
            }
            if (body != null) {
                Node node = body;
                synchronized (node) {
                    Node child = head.getNextSibling();
                    while (child != null && child != body) {
                        Node next = child.getNextSibling();
                        body.insertBefore(child, body.getFirstChild());
                        child = next;
                    }
                }
                return (HTMLElement)body;
            }
            body = new HTMLBodyElementImpl(this, "BODY");
            html.appendChild(body);
        }
        return (HTMLElement)body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setBody(HTMLElement newBody) {
        HTMLElement hTMLElement = newBody;
        synchronized (hTMLElement) {
            Element html = this.getDocumentElement();
            HTMLElement head = this.getHead();
            Element element = html;
            synchronized (element) {
                NodeList list = this.getElementsByTagName("BODY");
                if (list.getLength() > 0) {
                    Node body;
                    Node node = body = list.item(0);
                    synchronized (node) {
                        for (Node child = head; child != null; child = child.getNextSibling()) {
                            if (!(child instanceof Element)) continue;
                            if (child != body) {
                                html.insertBefore(newBody, child);
                            } else {
                                html.replaceChild(newBody, body);
                            }
                            return;
                        }
                        html.appendChild(newBody);
                    }
                    return;
                }
                html.appendChild(newBody);
            }
        }
    }

    @Override
    public synchronized Element getElementById(String elementId) {
        Element idElement = super.getElementById(elementId);
        if (idElement != null) {
            return idElement;
        }
        return this.getElementById(elementId, this);
    }

    @Override
    public NodeList getElementsByName(String elementname) {
        return new NameNodeListImpl(this, elementname);
    }

    @Override
    public final NodeList getElementsByTagName(String tagName) {
        return super.getElementsByTagName(tagName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (namespaceURI != null && !namespaceURI.isEmpty()) {
            return super.getElementsByTagNameNS(namespaceURI, localName.toUpperCase(Locale.ENGLISH));
        }
        return super.getElementsByTagName(localName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName, String localpart) throws DOMException {
        return this.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedname) {
        if (namespaceURI == null || namespaceURI.isEmpty()) {
            return this.createElement(qualifiedname);
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespaceURI)) {
            int index = qualifiedname.indexOf(58);
            if (index != -1) {
                return this.createElement(qualifiedname.substring(index + 1));
            }
            return this.createElement(qualifiedname);
        }
        return super.createElementNS(namespaceURI, qualifiedname);
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        ElementTypesHTMLHolder htmlHolder = ELEMENT_TYPES_HTML_LOWER.get(tagName);
        if (htmlHolder == null) {
            htmlHolder = ELEMENT_TYPES_HTML_UPPER.get(tagName.toUpperCase(Locale.ENGLISH));
        }
        if (htmlHolder != null) {
            try {
                return htmlHolder.ctr_.newInstance(this, tagName);
            }
            catch (Exception e) {
                throw new IllegalStateException("HTM15 Tag '" + tagName + "' associated with an Element class that failed to construct.", e);
            }
        }
        return new HTMLElementImpl(this, tagName);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return super.createAttribute(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getReferrer() {
        return null;
    }

    @Override
    public String getDomain() {
        return null;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public String getCookie() {
        return null;
    }

    @Override
    public void setCookie(String cookie) {
    }

    @Override
    public HTMLCollection getImages() {
        if (this.images_ == null) {
            this.images_ = new HTMLCollectionImpl(this.getBody(), 3);
        }
        return this.images_;
    }

    @Override
    public HTMLCollection getApplets() {
        if (this.applets_ == null) {
            this.applets_ = new HTMLCollectionImpl(this.getBody(), 4);
        }
        return this.applets_;
    }

    @Override
    public HTMLCollection getLinks() {
        if (this.links_ == null) {
            this.links_ = new HTMLCollectionImpl(this.getBody(), 5);
        }
        return this.links_;
    }

    @Override
    public HTMLCollection getForms() {
        if (this.forms_ == null) {
            this.forms_ = new HTMLCollectionImpl(this.getBody(), 2);
        }
        return this.forms_;
    }

    @Override
    public HTMLCollection getAnchors() {
        if (this.anchors_ == null) {
            this.anchors_ = new HTMLCollectionImpl(this.getBody(), 1);
        }
        return this.anchors_;
    }

    @Override
    public void open() {
        if (this.writer_ == null) {
            this.writer_ = new StringWriter();
        }
    }

    @Override
    public void close() {
        if (this.writer_ != null) {
            this.writer_ = null;
        }
    }

    @Override
    public void write(String text) {
        if (this.writer_ != null) {
            this.writer_.write(text);
        }
    }

    @Override
    public void writeln(String text) {
        if (this.writer_ != null) {
            this.writer_.write(text + "\n");
        }
    }

    @Override
    public Node cloneNode(boolean deep) {
        HTMLDocumentImpl newdoc = new HTMLDocumentImpl();
        this.cloneNode(newdoc, deep);
        return newdoc;
    }

    @Override
    protected boolean canRenameElements(String newNamespaceURI, String newNodeName, ElementImpl el) {
        if (el.getNamespaceURI() != null) {
            return newNamespaceURI != null;
        }
        Constructor<? extends HTMLElementImpl> newCtr = HTMLDocumentImpl.ELEMENT_TYPES_HTML_UPPER.get((String)newNodeName.toUpperCase((Locale)Locale.ENGLISH)).ctr_;
        Constructor<? extends HTMLElementImpl> oldCtr = HTMLDocumentImpl.ELEMENT_TYPES_HTML_UPPER.get((String)el.getTagName().toUpperCase((Locale)Locale.ENGLISH)).ctr_;
        return newCtr == oldCtr;
    }

    private Element getElementById(String elementId, Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            if (elementId.equals(((Element)child).getAttribute("id"))) {
                return (Element)child;
            }
            Element result = this.getElementById(elementId, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static {
        HashMap<String, Class> tMap = new HashMap<String, Class>();
        Arrays.stream(HTML5ELEMENTS).forEach(t -> tMap.put((String)t, HTMLElementImpl.class));
        tMap.put("A", HTMLAnchorElementImpl.class);
        tMap.put("APPLET", HTMLAppletElementImpl.class);
        tMap.put("AREA", HTMLAreaElementImpl.class);
        tMap.put("BASE", HTMLBaseElementImpl.class);
        tMap.put("BASEFONT", HTMLBaseFontElementImpl.class);
        tMap.put("BLOCKQUOTE", HTMLQuoteElementImpl.class);
        tMap.put("BODY", HTMLBodyElementImpl.class);
        tMap.put("BR", HTMLBRElementImpl.class);
        tMap.put("BUTTON", HTMLButtonElementImpl.class);
        tMap.put("DEL", HTMLModElementImpl.class);
        tMap.put("DIR", HTMLDirectoryElementImpl.class);
        tMap.put("DIV", HTMLDivElementImpl.class);
        tMap.put("DL", HTMLDListElementImpl.class);
        tMap.put("FIELDSET", HTMLFieldSetElementImpl.class);
        tMap.put("FONT", HTMLFontElementImpl.class);
        tMap.put("FORM", HTMLFormElementImpl.class);
        tMap.put("FRAME", HTMLFrameElementImpl.class);
        tMap.put("FRAMESET", HTMLFrameSetElementImpl.class);
        tMap.put("HEAD", HTMLHeadElementImpl.class);
        tMap.put("H1", HTMLHeadingElementImpl.class);
        tMap.put("H2", HTMLHeadingElementImpl.class);
        tMap.put("H3", HTMLHeadingElementImpl.class);
        tMap.put("H4", HTMLHeadingElementImpl.class);
        tMap.put("H5", HTMLHeadingElementImpl.class);
        tMap.put("H6", HTMLHeadingElementImpl.class);
        tMap.put("HR", HTMLHRElementImpl.class);
        tMap.put("HTML", HTMLHtmlElementImpl.class);
        tMap.put("IFRAME", HTMLIFrameElementImpl.class);
        tMap.put("IMG", HTMLImageElementImpl.class);
        tMap.put("INPUT", HTMLInputElementImpl.class);
        tMap.put("INS", HTMLModElementImpl.class);
        tMap.put("ISINDEX", HTMLIsIndexElementImpl.class);
        tMap.put("LABEL", HTMLLabelElementImpl.class);
        tMap.put("LEGEND", HTMLLegendElementImpl.class);
        tMap.put("LI", HTMLLIElementImpl.class);
        tMap.put("LINK", HTMLLinkElementImpl.class);
        tMap.put("MAP", HTMLMapElementImpl.class);
        tMap.put("MENU", HTMLMenuElementImpl.class);
        tMap.put("META", HTMLMetaElementImpl.class);
        tMap.put("OBJECT", HTMLObjectElementImpl.class);
        tMap.put("OL", HTMLOListElementImpl.class);
        tMap.put("OPTGROUP", HTMLOptGroupElementImpl.class);
        tMap.put("OPTION", HTMLOptionElementImpl.class);
        tMap.put("P", HTMLParagraphElementImpl.class);
        tMap.put("PARAM", HTMLParamElementImpl.class);
        tMap.put("PRE", HTMLPreElementImpl.class);
        tMap.put("Q", HTMLQuoteElementImpl.class);
        tMap.put("SCRIPT", HTMLScriptElementImpl.class);
        tMap.put("SELECT", HTMLSelectElementImpl.class);
        tMap.put("STYLE", HTMLStyleElementImpl.class);
        tMap.put("TABLE", HTMLTableElementImpl.class);
        tMap.put("CAPTION", HTMLTableCaptionElementImpl.class);
        tMap.put("TD", HTMLTableCellElementImpl.class);
        tMap.put("TH", HTMLTableCellElementImpl.class);
        tMap.put("COL", HTMLTableColElementImpl.class);
        tMap.put("COLGROUP", HTMLTableColElementImpl.class);
        tMap.put("TR", HTMLTableRowElementImpl.class);
        tMap.put("TBODY", HTMLTableSectionElementImpl.class);
        tMap.put("THEAD", HTMLTableSectionElementImpl.class);
        tMap.put("TFOOT", HTMLTableSectionElementImpl.class);
        tMap.put("TEXTAREA", HTMLTextAreaElementImpl.class);
        tMap.put("TITLE", HTMLTitleElementImpl.class);
        tMap.put("UL", HTMLUListElementImpl.class);
        tMap.forEach((key, value) -> {
            String uKey = key.toUpperCase(Locale.ENGLISH);
            String lKey = key.toLowerCase(Locale.ENGLISH);
            try {
                Constructor ctr = value.getConstructor(ELEMENT_CLASS_CTOR_SIGNATURE);
                ElementTypesHTMLHolder holder = new ElementTypesHTMLHolder(uKey, ctr);
                ELEMENT_TYPES_HTML_UPPER.put(uKey, holder);
                ELEMENT_TYPES_HTML_LOWER.put(lKey, holder);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new IllegalStateException("HTM15 Tag '" + key + "' associated with an Element class that failed to construct.\n" + key, ex);
            }
        });
    }

    static class ElementTypesHTMLHolder {
        public final String tagName_;
        public final Constructor<? extends HTMLElementImpl> ctr_;

        ElementTypesHTMLHolder(String tagName, Constructor<? extends HTMLElementImpl> ctr) {
            this.tagName_ = tagName;
            this.ctr_ = ctr;
        }
    }
}

