/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.directive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.htmlunit.csp.Directive;
import org.htmlunit.csp.Policy;
import org.htmlunit.csp.directive.HostSourceDirective;
import org.htmlunit.csp.value.Hash;
import org.htmlunit.csp.value.Nonce;

public class SourceExpressionDirective
extends HostSourceDirective {
    private static final String REPORT_SAMPLE = "'report-sample'";
    private static final String UNSAFE_INLINE = "'unsafe-inline'";
    private static final String STRICT_DYNAMIC = "'strict-dynamic'";
    private static final String UNSAFE_ALLOW_REDIRECTS = "'unsafe-allow-redirects'";
    private static final String UNSAFE_EVAL = "'unsafe-eval'";
    private static final String UNSAFE_HASHES = "'unsafe-hashes'";
    private static final String WASM_UNSAFE_EVAL = "'wasm-unsafe-eval'";
    private boolean unsafeInline_;
    private boolean unsafeEval_;
    private boolean strictDynamic_;
    private boolean unsafeHashes_;
    private boolean reportSample_;
    private boolean unsafeAllowRedirects_;
    private boolean unsafeWasm_;
    private final List<Nonce> nonces_ = new ArrayList<Nonce>();
    private final List<Hash> hashes_ = new ArrayList<Hash>();

    public SourceExpressionDirective(List<String> values, Directive.DirectiveErrorConsumer errors) {
        super(values);
        int index = 0;
        for (String token : values) {
            String lowcaseToken;
            switch (lowcaseToken = token.toLowerCase(Locale.ROOT)) {
                case "'unsafe-inline'": {
                    if (this.unsafeInline_) {
                        errors.add(Policy.Severity.Warning, "Duplicate source-expression 'unsafe-inline'", index);
                        break;
                    }
                    this.unsafeInline_ = true;
                    break;
                }
                case "'unsafe-eval'": {
                    if (this.unsafeEval_) {
                        errors.add(Policy.Severity.Warning, "Duplicate source-expression 'unsafe-eval'", index);
                        break;
                    }
                    this.unsafeEval_ = true;
                    break;
                }
                case "'strict-dynamic'": {
                    if (this.strictDynamic_) {
                        errors.add(Policy.Severity.Warning, "Duplicate source-expression 'strict-dynamic'", index);
                        break;
                    }
                    this.strictDynamic_ = true;
                    break;
                }
                case "'unsafe-hashes'": {
                    if (this.unsafeHashes_) {
                        errors.add(Policy.Severity.Warning, "Duplicate source-expression 'unsafe-hashes'", index);
                        break;
                    }
                    this.unsafeHashes_ = true;
                    break;
                }
                case "'wasm-unsafe-eval'": {
                    if (this.unsafeWasm_) {
                        errors.add(Policy.Severity.Warning, "Duplicate source-expression 'wasm-unsafe-eval'", index);
                        break;
                    }
                    this.unsafeWasm_ = true;
                    break;
                }
                case "'report-sample'": {
                    if (this.reportSample_) {
                        errors.add(Policy.Severity.Warning, "Duplicate source-expression 'report-sample'", index);
                        break;
                    }
                    this.reportSample_ = true;
                    break;
                }
                case "'unsafe-allow-redirects'": {
                    if (this.unsafeAllowRedirects_) {
                        errors.add(Policy.Severity.Warning, "Duplicate source-expression 'unsafe-allow-redirects'", index);
                        break;
                    }
                    this.unsafeAllowRedirects_ = true;
                    break;
                }
                case "'unsafe-redirect'": {
                    errors.add(Policy.Severity.Error, "'unsafe-redirect' has been removed from CSP as of version 2.0", index);
                    break;
                }
                case "'unsafe-hashed-attributes'": {
                    errors.add(Policy.Severity.Error, "'unsafe-hashed-attributes' was renamed to 'unsafe-hashes' in June 2018", index);
                    break;
                }
                default: {
                    if (lowcaseToken.startsWith("'nonce-")) {
                        Optional<Nonce> nonce = Nonce.parseNonce(token);
                        if (nonce.isPresent()) {
                            this.addNonce(nonce.get(), index, errors);
                            break;
                        }
                        errors.add(Policy.Severity.Error, "Unrecognised nonce " + token, index);
                        break;
                    }
                    if (lowcaseToken.startsWith("'sha")) {
                        Optional<Hash> hash = Hash.parseHash(token);
                        if (hash.isPresent()) {
                            this.addHash(hash.get(), index, errors);
                            break;
                        }
                        errors.add(Policy.Severity.Error, "'sha...' source-expression uses an unrecognized algorithm or does not match the base64-value grammar (or is missing its trailing \"'\")", index);
                        break;
                    }
                    this.addHostOrSchemeDuringConstruction(token, lowcaseToken, "source-expression", index, errors);
                }
            }
            ++index;
        }
        if (this.getNone() != null && values.size() > 1) {
            errors.add(Policy.Severity.Error, "'none' must not be combined with any other source-expression", 1);
        }
        if (values.isEmpty()) {
            errors.add(Policy.Severity.Error, "Source-expression lists cannot be empty (use 'none' instead)", -1);
        }
    }

    private boolean addNonce(Nonce nonce, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.nonces_.contains(nonce)) {
            errors.add(Policy.Severity.Warning, "Duplicate nonce " + nonce.toString(), index);
            return false;
        }
        this.nonces_.add(nonce);
        return true;
    }

    private boolean addHash(Hash hash, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.hashes_.contains(hash)) {
            errors.add(Policy.Severity.Warning, "Duplicate hash " + hash.toString(), index);
            return false;
        }
        if (hash.getBase64ValuePart().length() != hash.getAlgorithm().getLength()) {
            errors.add(Policy.Severity.Warning, "Wrong length for " + hash.getAlgorithm().toString() + ": expected " + hash.getAlgorithm().getLength() + ", got " + hash.getBase64ValuePart().length(), index);
        }
        if (hash.getBase64ValuePart().contains("_") || hash.getBase64ValuePart().contains("-")) {
            errors.add(Policy.Severity.Warning, "'_' and '-' in hashes can never match actual elements", index);
        }
        this.hashes_.add(hash);
        return true;
    }

    public boolean unsafeInline() {
        return this.unsafeInline_;
    }

    public boolean unsafeEval() {
        return this.unsafeEval_;
    }

    public boolean strictDynamic() {
        return this.strictDynamic_;
    }

    public boolean unsafeHashes() {
        return this.unsafeHashes_;
    }

    public boolean reportSample() {
        return this.reportSample_;
    }

    public boolean unsafeAllowRedirects() {
        return this.unsafeAllowRedirects_;
    }

    public boolean unsafeWasm() {
        return this.unsafeWasm_;
    }

    public List<Nonce> getNonces() {
        return Collections.unmodifiableList(this.nonces_);
    }

    public List<Hash> getHashes() {
        return Collections.unmodifiableList(this.hashes_);
    }
}

