/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.lc.type.impl.factory;

import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfoFactory;
import org.htmlunit.corejs.javascript.lc.type.VariableTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.BasicClassTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.EnumTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.InterfaceTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.VariableTypeInfoImpl;
import org.htmlunit.corejs.javascript.lc.type.impl.factory.FactoryBase;

public enum NoCacheFactory implements FactoryBase
{
    INSTANCE;


    @Override
    public TypeInfo create(Class<?> clazz) {
        TypeInfo predefined = TypeInfoFactory.matchPredefined(clazz);
        if (predefined != null) {
            return predefined;
        }
        if (clazz.isArray()) {
            return this.toArray(this.create(clazz.getComponentType()));
        }
        if (clazz.isEnum()) {
            return new EnumTypeInfo(clazz);
        }
        if (clazz.isInterface()) {
            return new InterfaceTypeInfo(clazz);
        }
        return new BasicClassTypeInfo(clazz);
    }

    @Override
    public TypeInfo create(TypeVariable<?> typeVariable) {
        return new VariableTypeInfoImpl(typeVariable, this);
    }

    @Override
    public Map<VariableTypeInfo, TypeInfo> getConsolidationMapping(Class<?> from) {
        if (from == null || from == Object.class || from.isPrimitive()) {
            return new HashMap<VariableTypeInfo, TypeInfo>();
        }
        return this.computeConsolidationMapping(from);
    }
}

