/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.lc.type.impl.factory;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.htmlunit.corejs.javascript.lc.type.ParameterizedTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeInfoFactory;
import org.htmlunit.corejs.javascript.lc.type.VariableTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.ArrayTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.ParameterizedTypeInfoImpl;

public interface FactoryBase
extends TypeInfoFactory {
    @Override
    default public TypeInfo create(GenericArrayType genericArrayType) {
        return this.toArray(this.create(genericArrayType.getGenericComponentType()));
    }

    @Override
    default public TypeInfo create(ParameterizedType parameterizedType) {
        return this.attachParam(this.create(parameterizedType.getRawType()), this.createList(parameterizedType.getActualTypeArguments()));
    }

    @Override
    default public TypeInfo create(WildcardType wildcardType) {
        Type[] upper = wildcardType.getUpperBounds();
        if (upper.length != 0 && upper[0] != Object.class) {
            return this.create(upper[0]);
        }
        Type[] lower = wildcardType.getLowerBounds();
        if (lower.length != 0) {
            return this.create(lower[0]);
        }
        return TypeInfo.NONE;
    }

    @Override
    default public TypeInfo toArray(TypeInfo component) {
        return new ArrayTypeInfo(component);
    }

    @Override
    default public TypeInfo attachParam(TypeInfo base, List<TypeInfo> params) {
        if (base instanceof ParameterizedTypeInfo) {
            base = ((ParameterizedTypeInfo)base).rawType();
        }
        return new ParameterizedTypeInfoImpl(base, params);
    }

    public static Map<VariableTypeInfo, TypeInfo> transformMapping(Map<VariableTypeInfo, TypeInfo> mapping, Map<VariableTypeInfo, TypeInfo> transformer) {
        if (mapping.isEmpty()) {
            return new HashMap<VariableTypeInfo, TypeInfo>();
        }
        if (mapping.size() == 1) {
            Map.Entry<VariableTypeInfo, TypeInfo> entry = mapping.entrySet().iterator().next();
            HashMap<VariableTypeInfo, TypeInfo> result = new HashMap<VariableTypeInfo, TypeInfo>();
            result.put(entry.getKey(), entry.getValue().consolidate(transformer));
            return result;
        }
        HashMap<VariableTypeInfo, TypeInfo> transformed = new HashMap<VariableTypeInfo, TypeInfo>(mapping);
        for (Map.Entry<VariableTypeInfo, TypeInfo> entry : transformed.entrySet()) {
            entry.setValue(entry.getValue().consolidate(transformer));
        }
        return transformed;
    }

    /*
     * WARNING - void declaration
     */
    default public Map<VariableTypeInfo, TypeInfo> computeConsolidationMapping(Class<?> type) {
        void var8_14;
        HashMap<VariableTypeInfo, TypeInfo> mapping = new HashMap<VariableTypeInfo, TypeInfo>();
        this.extractSuperMapping(type.getGenericSuperclass(), mapping);
        for (Type type2 : type.getGenericInterfaces()) {
            this.extractSuperMapping(type2, mapping);
        }
        Map<VariableTypeInfo, TypeInfo> superMapping = this.getConsolidationMapping(type.getSuperclass());
        Class<?>[] interfaces = type.getInterfaces();
        ArrayList<Map<VariableTypeInfo, TypeInfo>> interfaceMappings = new ArrayList<Map<VariableTypeInfo, TypeInfo>>(interfaces.length);
        Class<?>[] classArray = interfaces;
        int n = classArray.length;
        boolean bl = false;
        while (var8_14 < n) {
            Class<?> interface_ = classArray[var8_14];
            interfaceMappings.add(this.getConsolidationMapping(interface_));
            ++var8_14;
        }
        if (superMapping.isEmpty() && interfaceMappings.stream().allMatch(Map::isEmpty)) {
            return new HashMap<VariableTypeInfo, TypeInfo>(mapping);
        }
        HashMap<VariableTypeInfo, TypeInfo> hashMap = new HashMap<VariableTypeInfo, TypeInfo>(FactoryBase.transformMapping(superMapping, mapping));
        for (Map map : interfaceMappings) {
            hashMap.putAll(FactoryBase.transformMapping(map, mapping));
        }
        hashMap.putAll(mapping);
        return new HashMap<VariableTypeInfo, TypeInfo>(hashMap);
    }

    default public void extractSuperMapping(Type superType, Map<VariableTypeInfo, TypeInfo> pushTo) {
        Type[] args;
        if (!(superType instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterized = (ParameterizedType)superType;
        if (!(parameterized.getRawType() instanceof Class)) {
            return;
        }
        Class parent = (Class)parameterized.getRawType();
        TypeVariable<Class<T>>[] params = parent.getTypeParameters();
        if (params.length != (args = parameterized.getActualTypeArguments()).length) {
            throw new IllegalArgumentException(String.format("typeParameters.length != actualTypeArguments.length (%s != %s)", params.length, args.length));
        }
        for (int i = 0; i < args.length; ++i) {
            pushTo.put((VariableTypeInfo)this.create(params[i]), this.create(args[i]));
        }
    }
}

