/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.lc.type.impl;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.htmlunit.corejs.javascript.lc.type.ParameterizedTypeInfo;
import org.htmlunit.corejs.javascript.lc.type.TypeFormatContext;
import org.htmlunit.corejs.javascript.lc.type.TypeInfo;
import org.htmlunit.corejs.javascript.lc.type.impl.TypeInfoBase;

public final class ParameterizedTypeInfoImpl
extends TypeInfoBase
implements ParameterizedTypeInfo {
    private final TypeInfo rawType;
    private final List<TypeInfo> params;
    private int hashCode;

    public ParameterizedTypeInfoImpl(TypeInfo rawType, List<TypeInfo> params) {
        this.rawType = rawType;
        this.params = params;
        for (TypeInfo param : params) {
            Objects.requireNonNull(param);
        }
    }

    @Override
    public Class<?> asClass() {
        return this.rawType.asClass();
    }

    @Override
    public boolean is(Class<?> c) {
        return this.rawType.is(c);
    }

    @Override
    public TypeInfo param(int index) {
        if (index < 0 || index >= this.params.size()) {
            return TypeInfo.NONE;
        }
        TypeInfo got = this.params.get(index);
        return got == TypeInfo.OBJECT ? TypeInfo.NONE : got;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.rawType.hashCode() * 31 + this.params.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ParameterizedTypeInfoImpl && this.rawType.equals(((ParameterizedTypeInfoImpl)object).rawType) && this.params.equals(((ParameterizedTypeInfoImpl)object).params);
    }

    @Override
    public void append(TypeFormatContext ctx, StringBuilder builder) {
        ctx.formatParameterized(builder, this);
    }

    @Override
    public TypeInfo rawType() {
        return this.rawType;
    }

    @Override
    public List<TypeInfo> params() {
        return this.params;
    }

    @Override
    public Object newArray(int length) {
        return this.rawType.newArray(length);
    }

    @Override
    public void collectComponentClass(Consumer<Class<?>> collector) {
        this.rawType.collectComponentClass(collector);
        for (TypeInfo param : this.params) {
            param.collectComponentClass(collector);
        }
    }
}

