/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.ast;

import org.htmlunit.corejs.javascript.ast.AbstractObjectProperty;
import org.htmlunit.corejs.javascript.ast.AstNode;
import org.htmlunit.corejs.javascript.ast.NodeVisitor;

public class ObjectProperty
extends AbstractObjectProperty {
    private AstNode key;
    private AstNode value;
    private boolean shorthand;

    public void setNodeType(int nodeType) {
        if (nodeType != 118 && nodeType != 167 && nodeType != 168 && nodeType != 179) {
            throw new IllegalArgumentException("invalid node type: " + nodeType);
        }
        this.setType(nodeType);
    }

    public ObjectProperty() {
        this.type = 118;
    }

    public ObjectProperty(int pos) {
        super(pos);
        this.type = 118;
    }

    public void setKeyAndValue(AstNode key, AstNode value) {
        this.assertNotNull(key);
        this.assertNotNull(value);
        this.key = key;
        this.value = value;
        int beg = key.getPosition();
        int end = value.getPosition() + value.getLength();
        this.setBounds(beg, end);
        this.setLineColumnNumber(key.getLineno(), key.getColumn());
        key.setParent(this);
        value.setParent(this);
    }

    public void setIsGetterMethod() {
        this.type = 167;
    }

    public boolean isGetterMethod() {
        return this.type == 167;
    }

    public void setIsSetterMethod() {
        this.type = 168;
    }

    public boolean isSetterMethod() {
        return this.type == 168;
    }

    public void setIsNormalMethod() {
        this.type = 179;
    }

    public boolean isNormalMethod() {
        return this.type == 179;
    }

    public boolean isMethod() {
        return this.isGetterMethod() || this.isSetterMethod() || this.isNormalMethod();
    }

    public AstNode getKey() {
        return this.key;
    }

    public AstNode getValue() {
        return this.value;
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth + 1));
        if (this.isGetterMethod()) {
            sb.append("get ");
        } else if (this.isSetterMethod()) {
            sb.append("set ");
        }
        sb.append(this.key.toSource(this.getType() == 118 ? 0 : depth));
        if (!this.shorthand) {
            if (this.type == 118) {
                sb.append(": ");
            }
            sb.append(this.value.toSource(this.getType() == 118 ? 0 : depth + 1));
        }
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            this.key.visit(v);
            this.value.visit(v);
        }
    }
}

