/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.util.ArrayList;
import org.htmlunit.corejs.javascript.AbstractEcmaObjectOperations;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.CompoundOperationMap;
import org.htmlunit.corejs.javascript.Constructable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.EcmaError;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;

final class NativeReflect
extends ScriptableObject {
    private static final long serialVersionUID = 2920773905356325445L;
    private static final String REFLECT_TAG = "Reflect";

    public static Object init(Context cx, Scriptable scope, boolean sealed) {
        NativeReflect reflect = new NativeReflect();
        reflect.setPrototype(NativeReflect.getObjectPrototype(scope));
        reflect.setParentScope(scope);
        reflect.defineProperty(scope, "apply", 3, NativeReflect::apply, 2, 3);
        reflect.defineProperty(scope, "construct", 2, NativeReflect::construct, 2, 3);
        reflect.defineProperty(scope, "defineProperty", 3, NativeReflect::defineProperty, 2, 3);
        reflect.defineProperty(scope, "deleteProperty", 2, NativeReflect::deleteProperty, 2, 3);
        reflect.defineProperty(scope, "get", 2, NativeReflect::get, 2, 3);
        reflect.defineProperty(scope, "getOwnPropertyDescriptor", 2, NativeReflect::getOwnPropertyDescriptor, 2, 3);
        reflect.defineProperty(scope, "getPrototypeOf", 1, NativeReflect::getPrototypeOf, 2, 3);
        reflect.defineProperty(scope, "has", 2, NativeReflect::has, 2, 3);
        reflect.defineProperty(scope, "isExtensible", 1, NativeReflect::isExtensible, 2, 3);
        reflect.defineProperty(scope, "ownKeys", 1, NativeReflect::ownKeys, 2, 3);
        reflect.defineProperty(scope, "preventExtensions", 1, NativeReflect::preventExtensions, 2, 3);
        reflect.defineProperty(scope, "set", 3, NativeReflect::set, 2, 3);
        reflect.defineProperty(scope, "setPrototypeOf", 2, NativeReflect::setPrototypeOf, 2, 3);
        reflect.defineProperty(SymbolKey.TO_STRING_TAG, (Object)REFLECT_TAG, 3);
        if (sealed) {
            reflect.sealObject();
        }
        return reflect;
    }

    private NativeReflect() {
    }

    @Override
    public String getClassName() {
        return REFLECT_TAG;
    }

    private static Object apply(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length < 3) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Reflect.apply", "3", Integer.toString(args.length));
        }
        Scriptable callable = ScriptableObject.ensureScriptable(args[0]);
        if (args[1] instanceof Scriptable) {
            thisObj = (Scriptable)args[1];
        } else if (ScriptRuntime.isPrimitive(args[1])) {
            thisObj = cx.newObject(scope, "Object", new Object[]{args[1]});
        }
        if (ScriptRuntime.isSymbol(args[2])) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(args[2]));
        }
        ScriptableObject argumentsList = ScriptableObject.ensureScriptableObject(args[2]);
        return ScriptRuntime.applyOrCall(true, cx, scope, callable, new Object[]{thisObj, argumentsList});
    }

    private static Scriptable construct(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        BaseFunction ctorBaseFunction;
        Scriptable result;
        Scriptable newTarget;
        if (args.length < 1) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Reflect.construct", "3", Integer.toString(args.length));
        }
        if (!AbstractEcmaObjectOperations.isConstructor(cx, args[0])) {
            throw ScriptRuntime.typeErrorById("msg.not.ctor", ScriptRuntime.typeof(args[0]));
        }
        Constructable ctor = (Constructable)args[0];
        if (args.length < 2) {
            return ctor.construct(cx, scope, ScriptRuntime.emptyArgs);
        }
        if (args.length > 2 && !AbstractEcmaObjectOperations.isConstructor(cx, args[2])) {
            throw ScriptRuntime.typeErrorById("msg.not.ctor", ScriptRuntime.typeof(args[2]));
        }
        Object[] callArgs = ScriptRuntime.getApplyArguments(cx, args[1]);
        Object newTargetPrototype = null;
        if (args.length > 2 && (!((newTargetPrototype = (newTarget = ScriptableObject.ensureScriptable(args[2])) instanceof BaseFunction ? ((BaseFunction)newTarget).getPrototypeProperty() : newTarget.get("prototype", newTarget)) instanceof Scriptable) || ScriptRuntime.isSymbol(newTargetPrototype) || Undefined.isUndefined(newTargetPrototype))) {
            newTargetPrototype = null;
        }
        if (ctor instanceof BaseFunction && newTargetPrototype != null && (result = (ctorBaseFunction = (BaseFunction)ctor).createObject(cx, scope)) != null) {
            result.setPrototype((Scriptable)newTargetPrototype);
            Object val = ctorBaseFunction.call(cx, scope, result, callArgs);
            if (val instanceof Scriptable) {
                return (Scriptable)val;
            }
            return result;
        }
        Scriptable newScriptable = ctor.construct(cx, scope, callArgs);
        if (newTargetPrototype != null) {
            newScriptable.setPrototype((Scriptable)newTargetPrototype);
        }
        return newScriptable;
    }

    private static Object defineProperty(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length < 3) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Reflect.defineProperty", "3", Integer.toString(args.length));
        }
        ScriptableObject target = NativeReflect.checkTarget(args);
        ScriptableObject desc = ScriptableObject.ensureScriptableObject(args[2]);
        Object key = args[1];
        try {
            if (key instanceof Symbol) {
                return target.defineOwnProperty(cx, key, desc);
            }
            String propertyKey = ScriptRuntime.toString(ScriptRuntime.toPrimitive(key, ScriptRuntime.StringClass));
            return target.defineOwnProperty(cx, propertyKey, desc);
        }
        catch (EcmaError e) {
            return false;
        }
    }

    private static Object deleteProperty(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptableObject target = NativeReflect.checkTarget(args);
        if (args.length > 1) {
            if (ScriptRuntime.isSymbol(args[1])) {
                return ScriptableObject.deleteProperty((Scriptable)target, (Symbol)args[1]);
            }
            return ScriptableObject.deleteProperty((Scriptable)target, ScriptRuntime.toString(args[1]));
        }
        return false;
    }

    private static Object get(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptableObject target = NativeReflect.checkTarget(args);
        if (args.length > 1) {
            if (ScriptRuntime.isSymbol(args[1])) {
                Object prop = ScriptableObject.getProperty((Scriptable)target, (Symbol)args[1]);
                return prop == Scriptable.NOT_FOUND ? Undefined.SCRIPTABLE_UNDEFINED : prop;
            }
            if (args[1] instanceof Number) {
                Object prop = ScriptableObject.getProperty((Scriptable)target, ScriptRuntime.toIndex(args[1]));
                return prop == Scriptable.NOT_FOUND ? Undefined.SCRIPTABLE_UNDEFINED : prop;
            }
            Object prop = ScriptableObject.getProperty((Scriptable)target, ScriptRuntime.toString(args[1]));
            return prop == Scriptable.NOT_FOUND ? Undefined.SCRIPTABLE_UNDEFINED : prop;
        }
        return Undefined.SCRIPTABLE_UNDEFINED;
    }

    private static Scriptable getOwnPropertyDescriptor(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptableObject target = NativeReflect.checkTarget(args);
        if (args.length > 1) {
            if (ScriptRuntime.isSymbol(args[1])) {
                ScriptableObject desc = target.getOwnPropertyDescriptor(cx, args[1]);
                return desc == null ? Undefined.SCRIPTABLE_UNDEFINED : desc;
            }
            ScriptableObject desc = target.getOwnPropertyDescriptor(cx, ScriptRuntime.toString(args[1]));
            return desc == null ? Undefined.SCRIPTABLE_UNDEFINED : desc;
        }
        return Undefined.SCRIPTABLE_UNDEFINED;
    }

    private static Scriptable getPrototypeOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptableObject target = NativeReflect.checkTarget(args);
        return target.getPrototype();
    }

    private static Object has(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptableObject target = NativeReflect.checkTarget(args);
        if (args.length > 1) {
            if (ScriptRuntime.isSymbol(args[1])) {
                return ScriptableObject.hasProperty((Scriptable)target, (Symbol)args[1]);
            }
            return ScriptableObject.hasProperty((Scriptable)target, ScriptRuntime.toString(args[1]));
        }
        return false;
    }

    private static Object isExtensible(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptableObject target = NativeReflect.checkTarget(args);
        return target.isExtensible();
    }

    private static Scriptable ownKeys(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object[] ids;
        ScriptableObject target = NativeReflect.checkTarget(args);
        ArrayList<String> strings = new ArrayList<String>();
        ArrayList<Object> symbols = new ArrayList<Object>();
        try (Object[] map = target.startCompoundOp(false);){
            ids = target.getIds((CompoundOperationMap)map, true, true);
        }
        for (Object o : ids) {
            if (o instanceof Symbol) {
                symbols.add(o);
                continue;
            }
            strings.add(ScriptRuntime.toString(o));
        }
        Object[] keys = new Object[strings.size() + symbols.size()];
        System.arraycopy(strings.toArray(), 0, keys, 0, strings.size());
        System.arraycopy(symbols.toArray(), 0, keys, strings.size(), symbols.size());
        return cx.newArray(scope, keys);
    }

    private static Object preventExtensions(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptableObject target = NativeReflect.checkTarget(args);
        return target.preventExtensions();
    }

    private static Object set(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ScriptableObject descriptor;
        ScriptableObject receiver;
        ScriptableObject target = NativeReflect.checkTarget(args);
        if (args.length < 2) {
            return true;
        }
        ScriptableObject scriptableObject = receiver = args.length > 3 ? ScriptableObject.ensureScriptableObject(args[3]) : target;
        if (receiver != target && (descriptor = target.getOwnPropertyDescriptor(cx, args[1])) != null) {
            Object setter = descriptor.get("set");
            if (setter != null && setter != NOT_FOUND) {
                ((Function)setter).call(cx, scope, receiver, new Object[]{args[2]});
                return true;
            }
            if (Boolean.FALSE.equals(descriptor.get("configurable"))) {
                return false;
            }
        }
        if (ScriptRuntime.isSymbol(args[1])) {
            receiver.put((Symbol)args[1], (Scriptable)receiver, args[2]);
        } else {
            ScriptRuntime.StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(args[1]);
            if (s.stringId == null) {
                receiver.put(s.index, (Scriptable)receiver, args[2]);
            } else {
                receiver.put(s.stringId, (Scriptable)receiver, args[2]);
            }
        }
        return true;
    }

    private static Object setPrototypeOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length < 2) {
            throw ScriptRuntime.typeErrorById("msg.method.missing.parameter", "Reflect.js_setPrototypeOf", "2", Integer.toString(args.length));
        }
        ScriptableObject target = NativeReflect.checkTarget(args);
        if (target.getPrototype() == args[1]) {
            return true;
        }
        if (!target.isExtensible()) {
            return false;
        }
        if (args[1] == null) {
            target.setPrototype(null);
            return true;
        }
        if (ScriptRuntime.isSymbol(args[1])) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(args[0]));
        }
        ScriptableObject proto = ScriptableObject.ensureScriptableObject(args[1]);
        if (target.getPrototype() == proto) {
            return true;
        }
        for (Scriptable p = proto; p != null; p = p.getPrototype()) {
            if (target != p) continue;
            return false;
        }
        target.setPrototype(proto);
        return true;
    }

    private static ScriptableObject checkTarget(Object[] args) {
        if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
            Object argument = args.length == 0 ? Undefined.instance : args[0];
            throw ScriptRuntime.typeErrorById("msg.no.properties", ScriptRuntime.toString(argument));
        }
        if (ScriptRuntime.isSymbol(args[0])) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(args[0]));
        }
        return ScriptableObject.ensureScriptableObject(args[0]);
    }
}

