/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Initializable;
import org.htmlunit.corejs.javascript.Kit;
import org.htmlunit.corejs.javascript.RhinoException;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;

public final class LazilyLoadedCtor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int STATE_BEFORE_INIT = 0;
    private static final int STATE_INITIALIZING = 1;
    private static final int STATE_WITH_VALUE = 2;
    private final Scriptable scope;
    private final Initializable initializer;
    private final String propertyName;
    private final boolean sealed;
    private final boolean privileged;
    private Object initializedValue;
    private int state;

    public LazilyLoadedCtor(ScriptableObject scope, String propertyName, boolean sealed, boolean privileged, Initializable initializer) {
        this.scope = scope;
        this.propertyName = propertyName;
        this.sealed = sealed;
        this.privileged = privileged;
        this.state = 0;
        this.initializer = initializer;
        scope.addLazilyInitializedValue(propertyName, 0, this, 2);
    }

    public LazilyLoadedCtor(ScriptableObject scope, String propertyName, boolean sealed, Initializable initializer, boolean privileged) {
        this(scope, propertyName, sealed, privileged, initializer);
    }

    public LazilyLoadedCtor(ScriptableObject scope, String propertyName, String className, boolean sealed) {
        this(scope, propertyName, className, sealed, false);
    }

    public LazilyLoadedCtor(ScriptableObject scope, String propertyName, String className, boolean sealed, boolean privileged) {
        this(scope, propertyName, sealed, privileged, (lcx, lscope, lsealed) -> LazilyLoadedCtor.buildUsingReflection(lscope, className, propertyName, lsealed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        LazilyLoadedCtor lazilyLoadedCtor = this;
        synchronized (lazilyLoadedCtor) {
            if (this.state == 1) {
                throw new IllegalStateException("Recursive initialization for " + this.propertyName);
            }
            if (this.state == 0) {
                this.state = 1;
                Object value = Scriptable.NOT_FOUND;
                try {
                    value = this.buildValue();
                }
                finally {
                    this.initializedValue = value;
                    this.state = 2;
                }
            }
        }
    }

    Object getValue() {
        if (this.state != 2) {
            throw new IllegalStateException(this.propertyName);
        }
        return this.initializedValue;
    }

    private Object buildValue() {
        if (this.privileged) {
            return AccessController.doPrivileged(() -> this.buildValueInternal());
        }
        return this.buildValueInternal();
    }

    private Object buildValueInternal() {
        Context cx = Context.getCurrentContext();
        Object value = this.initializer.initialize(cx, this.scope, this.sealed);
        if (value != null) {
            return value;
        }
        return this.scope.get(this.propertyName, this.scope);
    }

    private static Object buildUsingReflection(Scriptable scope, String className, String propertyName, boolean sealed) {
        Class<? extends Scriptable> cl = LazilyLoadedCtor.cast(Kit.classOrNull(className));
        if (cl != null) {
            try {
                Object value = ScriptableObject.buildClassCtor(scope, cl, sealed, false);
                if (value != null) {
                    return value;
                }
                value = scope.get(propertyName, scope);
                if (value != Scriptable.NOT_FOUND) {
                    return value;
                }
            }
            catch (InvocationTargetException ex) {
                Throwable target = ex.getTargetException();
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
            }
            catch (IllegalAccessException | InstantiationException | SecurityException | RhinoException exception) {
                // empty catch block
            }
        }
        return Scriptable.NOT_FOUND;
    }

    private static Class<? extends Scriptable> cast(Class<?> cl) {
        return cl;
    }
}

