/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;

public final class WebAssert {
    private WebAssert() {
    }

    public static void assertTitleEquals(HtmlPage page, String title) {
        String s = page.getTitleText();
        if (!title.equals(s)) {
            String msg = "Page title '" + s + "' does not match expected title '" + title + "'.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertTitleContains(HtmlPage page, String titlePortion) {
        String s = page.getTitleText();
        if (!s.contains(titlePortion)) {
            String msg = "Page title '" + s + "' does not contain the expected substring '" + titlePortion + "'.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertTitleMatches(HtmlPage page, String regex) {
        String s = page.getTitleText();
        if (!s.matches(regex)) {
            String msg = "Page title '" + s + "' does not match the expected regular expression '" + regex + "'.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertElementPresent(HtmlPage page, String id) {
        try {
            page.getHtmlElementById(id);
        }
        catch (ElementNotFoundException e) {
            String msg = "Expected element with ID '" + id + "' was not found on the page.";
            throw new AssertionError(msg, e);
        }
    }

    public static void assertElementPresentByXPath(HtmlPage page, String xpath) {
        List elements = page.getByXPath(xpath);
        if (elements.isEmpty()) {
            String msg = "No elements found matching the XPath expression '" + xpath + "'.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertElementNotPresent(HtmlPage page, String id) {
        try {
            page.getHtmlElementById(id);
        }
        catch (ElementNotFoundException e) {
            return;
        }
        String msg = "Found unexpected element with ID '" + id + "' on the page.";
        throw new AssertionError((Object)msg);
    }

    public static void assertElementNotPresentByXPath(HtmlPage page, String xpath) {
        List elements = page.getByXPath(xpath);
        if (!elements.isEmpty()) {
            String msg = "Found " + elements.size() + " unexpected element(s) matching the XPath expression '" + xpath + "'.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertTextPresent(HtmlPage page, String text) {
        if (!page.asNormalizedText().contains(text)) {
            String msg = "Expected text '" + text + "' was not found on the page.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertTextPresentInElement(HtmlPage page, String text, String id) {
        try {
            Object element = page.getHtmlElementById(id);
            if (!((DomNode)element).asNormalizedText().contains(text)) {
                String msg = "Element with ID '" + id + "' does not contain the expected text '" + text + "'.";
                throw new AssertionError((Object)msg);
            }
        }
        catch (ElementNotFoundException e) {
            String msg = "Cannot verify text content: element with ID '" + id + "' was not found on the page.";
            throw new AssertionError(msg, e);
        }
    }

    public static void assertTextNotPresent(HtmlPage page, String text) {
        if (page.asNormalizedText().contains(text)) {
            String msg = "Found unexpected text '" + text + "' on the page.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertTextNotPresentInElement(HtmlPage page, String text, String id) {
        try {
            Object element = page.getHtmlElementById(id);
            if (((DomNode)element).asNormalizedText().contains(text)) {
                String msg = "Element with ID '" + id + "' contains unexpected text '" + text + "'.";
                throw new AssertionError((Object)msg);
            }
        }
        catch (ElementNotFoundException e) {
            String msg = "Cannot verify text content: element with ID '" + id + "' was not found on the page.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertLinkPresent(HtmlPage page, String id) {
        try {
            page.getDocumentElement().getOneHtmlElementByAttribute("a", "id", id);
        }
        catch (ElementNotFoundException e) {
            String msg = "Expected link with ID '" + id + "' was not found on the page.";
            throw new AssertionError(msg, e);
        }
    }

    public static void assertLinkNotPresent(HtmlPage page, String id) {
        try {
            page.getDocumentElement().getOneHtmlElementByAttribute("a", "id", id);
            String msg = "Found unexpected link with ID '" + id + "' on the page.";
            throw new AssertionError((Object)msg);
        }
        catch (ElementNotFoundException elementNotFoundException) {
            return;
        }
    }

    public static void assertLinkPresentWithText(HtmlPage page, String text) {
        boolean found = false;
        for (HtmlAnchor a : page.getAnchors()) {
            if (!a.asNormalizedText().contains(text)) continue;
            found = true;
            break;
        }
        if (!found) {
            String msg = "Expected link containing text '" + text + "' was not found on the page.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertLinkNotPresentWithText(HtmlPage page, String text) {
        boolean found = false;
        for (HtmlAnchor a : page.getAnchors()) {
            if (!a.asNormalizedText().contains(text)) continue;
            found = true;
            break;
        }
        if (found) {
            String msg = "Found unexpected link containing text '" + text + "' on the page.";
            throw new AssertionError((Object)msg);
        }
    }

    public static void assertFormPresent(HtmlPage page, String name) {
        try {
            page.getFormByName(name);
        }
        catch (ElementNotFoundException e) {
            String msg = "Expected form with name '" + name + "' was not found on the page.";
            throw new AssertionError(msg, e);
        }
    }

    public static void assertFormNotPresent(HtmlPage page, String name) {
        try {
            page.getFormByName(name);
        }
        catch (ElementNotFoundException e) {
            return;
        }
        String msg = "Found unexpected form with name '" + name + "' on the page.";
        throw new AssertionError((Object)msg);
    }

    public static void assertInputPresent(HtmlPage page, String name) {
        String xpath = "//input[@name='" + name + "']";
        List list = page.getByXPath(xpath);
        if (list.isEmpty()) {
            throw new AssertionError((Object)("Expected input element with name '" + name + "' was not found on the page."));
        }
    }

    public static void assertInputNotPresent(HtmlPage page, String name) {
        String xpath = "//input[@name='" + name + "']";
        List list = page.getByXPath(xpath);
        if (!list.isEmpty()) {
            throw new AssertionError((Object)("Found unexpected input element with name '" + name + "' on the page."));
        }
    }

    public static void assertInputContainsValue(HtmlPage page, String name, String value) {
        String xpath = "//input[@name='" + name + "']";
        List list = page.getByXPath(xpath);
        if (list.isEmpty()) {
            throw new AssertionError((Object)("Expected input element with name '" + name + "' was not found on the page."));
        }
        HtmlInput input = (HtmlInput)list.get(0);
        String s = input.getValue();
        if (!s.equals(value)) {
            throw new AssertionError((Object)("Input element '" + name + "' has value '" + s + "' but expected '" + value + "'."));
        }
    }

    public static void assertInputDoesNotContainValue(HtmlPage page, String name, String value) {
        String xpath = "//input[@name='" + name + "']";
        List list = page.getByXPath(xpath);
        if (list.isEmpty()) {
            throw new AssertionError((Object)("Expected input element with name '" + name + "' was not found on the page."));
        }
        HtmlInput input = (HtmlInput)list.get(0);
        String s = input.getValue();
        if (s.equals(value)) {
            throw new AssertionError((Object)("Input element '" + name + "' has unexpected value '" + s + "'."));
        }
    }

    public static void assertAllTabIndexAttributesSet(HtmlPage page) {
        List<String> tags = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
        for (String tag : tags) {
            for (HtmlElement element : page.getDocumentElement().getStaticElementsByTagName(tag)) {
                Short tabIndex = element.getTabIndex();
                if (tabIndex != null && !HtmlElement.TAB_INDEX_OUT_OF_BOUNDS.equals(tabIndex)) continue;
                String s = element.getAttributeDirect("tabindex");
                throw new AssertionError((Object)("Invalid tabindex value '" + s + "' found on element."));
            }
        }
    }

    public static void assertAllAccessKeyAttributesUnique(HtmlPage page) {
        ArrayList<String> list = new ArrayList<String>();
        for (HtmlElement element : page.getHtmlElementDescendants()) {
            String key = element.getAttributeDirect("accesskey");
            if (key == null || key.isEmpty()) continue;
            if (list.contains(key)) {
                throw new AssertionError((Object)("Duplicate access key '" + key + "' found on the page."));
            }
            list.add(key);
        }
    }

    public static void assertAllIdAttributesUnique(HtmlPage page) {
        ArrayList<String> list = new ArrayList<String>();
        for (HtmlElement element : page.getHtmlElementDescendants()) {
            String id = element.getId();
            if (id == null || id.isEmpty()) continue;
            if (list.contains(id)) {
                throw new AssertionError((Object)("Duplicate element ID '" + id + "' found on the page."));
            }
            list.add(id);
        }
    }

    public static void notNull(String description, Object object) {
        if (object == null) {
            throw new NullPointerException(description);
        }
    }
}

