/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.keyverifier;

import io.jenkins.cli.shaded.org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.OpenSshCertificate;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.net.SocketAddress;
import java.security.PublicKey;

public class RequiredServerKeyVerifier
extends AbstractLoggingBean
implements ServerKeyVerifier {
    private final PublicKey requiredKey;

    public RequiredServerKeyVerifier(PublicKey requiredKey) {
        this.requiredKey = requiredKey;
    }

    public final PublicKey getRequiredKey() {
        return this.requiredKey;
    }

    @Override
    public boolean verifyServerKey(ClientSession sshClientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        boolean sameKey = KeyUtils.compareKeys(this.requiredKey, serverKey);
        if (!sameKey) {
            PublicKey req = this.requiredKey instanceof OpenSshCertificate ? ((OpenSshCertificate)this.requiredKey).getCaPubKey() : this.requiredKey;
            PublicKey srv = serverKey instanceof OpenSshCertificate ? ((OpenSshCertificate)serverKey).getCaPubKey() : serverKey;
            sameKey = KeyUtils.compareKeys(req, srv);
        }
        if (sameKey) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Server at {} presented expected key: {}", (Object)remoteAddress, (Object)BufferUtils.toHex(serverKey.getEncoded()));
            }
            return true;
        }
        this.log.error("Server at {} presented wrong key: {}", (Object)remoteAddress, (Object)BufferUtils.toHex(serverKey.getEncoded()));
        return false;
    }
}

