/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.commons.io.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public class ByteArraySeekableByteChannel
implements SeekableByteChannel {
    private static final int RESIZE_LIMIT = 0x3FFFFFFF;
    private byte[] data;
    private volatile boolean closed;
    private int position;
    private int size;
    private final ReentrantLock lock = new ReentrantLock();

    public static ByteArraySeekableByteChannel wrap(byte[] bytes) {
        Objects.requireNonNull(bytes, "bytes");
        return new ByteArraySeekableByteChannel(bytes);
    }

    public ByteArraySeekableByteChannel() {
        this(8192);
    }

    private ByteArraySeekableByteChannel(byte[] data) {
        this.data = data;
        this.position = 0;
        this.size = data.length;
    }

    public ByteArraySeekableByteChannel(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size must be non-negative");
        }
        this.data = new byte[size];
        this.position = 0;
        this.size = 0;
    }

    public byte[] array() {
        return this.data;
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private int checkRange(long newSize, String method) {
        if (newSize < 0L || newSize > 0x7FFFFFF7L) {
            throw new IllegalArgumentException(String.format("%s must be in range [0..%,d]: %,d", method, 0x7FFFFFF7, newSize));
        }
        return (int)newSize;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public long position() throws ClosedChannelException {
        this.checkOpen();
        this.lock.lock();
        try {
            long l = this.position;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.checkOpen();
        int intPos = this.checkRange(newPosition, "position()");
        this.lock.lock();
        try {
            this.position = intPos;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer buf) throws IOException {
        this.checkOpen();
        this.lock.lock();
        try {
            int wanted = buf.remaining();
            int possible = this.size - this.position;
            if (possible <= 0) {
                int n = -1;
                return n;
            }
            if (wanted > possible) {
                wanted = possible;
            }
            buf.put(this.data, this.position, wanted);
            this.position += wanted;
            int n = wanted;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void resize(int newLength) {
        int len = this.data.length;
        if (len == 0) {
            len = 1;
        }
        if (newLength < 0x3FFFFFFF) {
            while (len < newLength) {
                len <<= 1;
            }
        } else {
            len = newLength;
        }
        this.data = Arrays.copyOf(this.data, len);
    }

    @Override
    public long size() throws ClosedChannelException {
        this.checkOpen();
        this.lock.lock();
        try {
            long l = this.size;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel truncate(long newSize) throws ClosedChannelException {
        this.checkOpen();
        int intSize = this.checkRange(newSize, "truncate()");
        this.lock.lock();
        try {
            if (this.size > intSize) {
                this.size = intSize;
            }
            if (this.position > intSize) {
                this.position = intSize;
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer b) throws IOException {
        this.checkOpen();
        this.lock.lock();
        try {
            int wanted = b.remaining();
            int possibleWithoutResize = Math.max(0, this.size - this.position);
            if (wanted > possibleWithoutResize) {
                int newSize = this.position + wanted;
                if (newSize < 0 || newSize > 0x7FFFFFF7) {
                    throw new OutOfMemoryError("required array size " + Integer.toUnsignedString(newSize) + " too large");
                }
                this.resize(newSize);
            }
            b.get(this.data, this.position, wanted);
            this.position += wanted;
            if (this.size < this.position) {
                this.size = this.position;
            }
            int n = wanted;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

