/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.auth.pubkey;

import io.jenkins.cli.shaded.org.apache.sshd.common.AttributeRepository;
import io.jenkins.cli.shaded.org.apache.sshd.common.RuntimeSshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.OpenSshCertificate;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.session.ServerSession;
import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class CachingPublicKeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    public static final AttributeRepository.AttributeKey<Map<PublicKey, Boolean>> CACHE_ATTRIBUTE = new AttributeRepository.AttributeKey();
    protected final PublickeyAuthenticator authenticator;

    public CachingPublicKeyAuthenticator(PublickeyAuthenticator authenticator) {
        this.authenticator = Objects.requireNonNull(authenticator, "No delegate authenticator");
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        Map<PublicKey, Boolean> map = this.resolveCachedResults(username, key, session);
        Boolean result = map.get(key);
        if (result == null) {
            try {
                result = this.authenticator.authenticate(username, key, session);
            }
            catch (Error e) {
                this.warn("authenticate({}@{}) failed ({}) to consult delegate for {} key={}: {}", username, session, e.getClass().getSimpleName(), KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key), e.getMessage(), e);
                throw new RuntimeSshException(e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({}@{}) cache result={} for {} key={}", username, session, result, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
            }
            if (!(key instanceof OpenSshCertificate)) {
                map.put(key, result);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}@{}) use cached result={} for {} key={}", username, session, result, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
        }
        return result;
    }

    protected Map<PublicKey, Boolean> resolveCachedResults(String username, PublicKey key, ServerSession session) {
        return session.computeAttributeIfAbsent(CACHE_ATTRIBUTE, attr -> new ConcurrentHashMap());
    }
}

