/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.threads;

import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public interface CloseableExecutorService
extends ExecutorService,
Closeable {
    default public boolean awaitTermination(Duration timeout) throws InterruptedException {
        Objects.requireNonNull(timeout, "No timeout specified");
        return this.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    default public void close() {
        try {
            Closeable.super.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

