/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.asn1.x509;

import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Encodable;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Integer;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Object;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1OctetString;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Primitive;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Sequence;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.DEROctetString;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.DERSequence;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.DERTaggedObject;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x509.Extension;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x509.Extensions;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x509.GeneralNames;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.digests.SHA1Digest;
import io.jenkins.cli.shaded.org.bouncycastle.util.Arrays;
import io.jenkins.cli.shaded.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.util.Enumeration;

public class AuthorityKeyIdentifier
extends ASN1Object {
    ASN1OctetString keyIdentifier = null;
    GeneralNames certissuer = null;
    ASN1Integer certserno = null;

    public static AuthorityKeyIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new AuthorityKeyIdentifier(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static AuthorityKeyIdentifier getInstance(Object object) {
        if (object instanceof AuthorityKeyIdentifier) {
            return (AuthorityKeyIdentifier)object;
        }
        if (object != null) {
            return new AuthorityKeyIdentifier(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static AuthorityKeyIdentifier fromExtensions(Extensions extensions) {
        return AuthorityKeyIdentifier.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.authorityKeyIdentifier));
    }

    protected AuthorityKeyIdentifier(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.keyIdentifier = ASN1OctetString.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 1: {
                    this.certissuer = GeneralNames.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 2: {
                    this.certserno = ASN1Integer.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("illegal tag");
        }
    }

    public AuthorityKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(subjectPublicKeyInfo, null, null);
    }

    public AuthorityKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo, GeneralNames generalNames, BigInteger bigInteger) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        this.keyIdentifier = new DEROctetString(byArray);
        this.certissuer = generalNames;
        this.certserno = bigInteger != null ? new ASN1Integer(bigInteger) : null;
    }

    public AuthorityKeyIdentifier(GeneralNames generalNames, BigInteger bigInteger) {
        this((byte[])null, generalNames, bigInteger);
    }

    public AuthorityKeyIdentifier(byte[] byArray) {
        this(byArray, null, null);
    }

    public AuthorityKeyIdentifier(byte[] byArray, GeneralNames generalNames, BigInteger bigInteger) {
        this.keyIdentifier = byArray != null ? new DEROctetString(Arrays.clone(byArray)) : null;
        this.certissuer = generalNames;
        this.certserno = bigInteger != null ? new ASN1Integer(bigInteger) : null;
    }

    public byte[] getKeyIdentifier() {
        return this.getKeyIdentifierOctets();
    }

    public byte[] getKeyIdentifierOctets() {
        if (this.keyIdentifier != null) {
            return this.keyIdentifier.getOctets();
        }
        return null;
    }

    public ASN1OctetString getKeyIdentifierObject() {
        return this.keyIdentifier;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.certissuer;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        if (this.certserno != null) {
            return this.certserno.getValue();
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        if (this.keyIdentifier != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, (ASN1Encodable)this.keyIdentifier));
        }
        if (this.certissuer != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.certissuer));
        }
        if (this.certserno != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, (ASN1Encodable)this.certserno));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        String string = this.keyIdentifier != null ? Hex.toHexString(this.keyIdentifier.getOctets()) : "null";
        return "AuthorityKeyIdentifier: KeyID(" + string + ")";
    }
}

