/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.digest;

import io.jenkins.cli.shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.digests.RIPEMD320Digest;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.macs.HMac;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class RIPEMD320 {
    private RIPEMD320() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD320Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new RIPEMD320Digest((RIPEMD320Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new RIPEMD320Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD320", 320, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD320.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.RIPEMD320", PREFIX + "$Digest");
            this.addHMACAlgorithm(configurableProvider, "RIPEMD320", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }
}

