/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.security.eddsa;

import io.jenkins.cli.shaded.net.i2p.crypto.eddsa.EdDSAPrivateKey;
import io.jenkins.cli.shaded.net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import io.jenkins.cli.shaded.net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import io.jenkins.cli.shaded.net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.eddsa.generic.EdDSASupport;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.eddsa.generic.GenericEd25519PEMResourceKeyParser;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;

public class Ed25519PEMResourceKeyParser
extends GenericEd25519PEMResourceKeyParser {
    public static final Ed25519PEMResourceKeyParser INSTANCE = new Ed25519PEMResourceKeyParser();

    public static EdDSAPrivateKey decodeEdDSAPrivateKey(byte[] keyData) throws IOException, GeneralSecurityException {
        return (EdDSAPrivateKey)EdDSAPrivateKey.class.cast(EdDSASupport.decodeEdDSAPrivateKey(keyData));
    }

    public static EdDSAPrivateKey generateEdDSAPrivateKey(byte[] seed) throws GeneralSecurityException {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        EdDSANamedCurveSpec params = EdDSANamedCurveTable.getByName("Ed25519");
        EdDSAPrivateKeySpec keySpec = new EdDSAPrivateKeySpec(seed, params);
        KeyFactory factory = SecurityUtils.getKeyFactory("EdDSA");
        return (EdDSAPrivateKey)EdDSAPrivateKey.class.cast(factory.generatePrivate(keySpec));
    }
}

