/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.session;

import io.jenkins.cli.shaded.org.apache.sshd.client.ClientAuthenticationManager;
import io.jenkins.cli.shaded.org.apache.sshd.client.ClientFactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ChannelDirectTcpip;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ChannelExec;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ChannelShell;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ChannelSubsystem;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ClientChannel;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ClientChannelEvent;
import io.jenkins.cli.shaded.org.apache.sshd.client.future.AuthFuture;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientProxyConnectorHolder;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.forward.DynamicPortForwardingTracker;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.forward.ExplicitPortForwardingTracker;
import io.jenkins.cli.shaded.org.apache.sshd.common.AttributeRepository;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.forward.PortForwardingManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.KeyExchangeFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.output.NoCloseOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.output.NullOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.net.SshdSocketAddress;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public interface ClientSession
extends Session,
ClientProxyConnectorHolder,
ClientAuthenticationManager,
PortForwardingManager {
    public static final Set<ClientChannelEvent> REMOTE_COMMAND_WAIT_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.CLOSED));

    public SocketAddress getConnectAddress();

    public AttributeRepository getConnectionContext();

    public AuthFuture auth() throws IOException;

    public PublicKey getServerKey();

    public ClientChannel createChannel(String var1) throws IOException;

    public ClientChannel createChannel(String var1, String var2) throws IOException;

    default public ChannelShell createShellChannel() throws IOException {
        return this.createShellChannel(null, Collections.emptyMap());
    }

    public ChannelShell createShellChannel(PtyChannelConfigurationHolder var1, Map<String, ?> var2) throws IOException;

    default public ChannelExec createExecChannel(String command) throws IOException {
        return this.createExecChannel(command, null, Collections.emptyMap());
    }

    default public ChannelExec createExecChannel(String command, PtyChannelConfigurationHolder ptyConfig, Map<String, ?> env) throws IOException {
        return this.createExecChannel(command, StandardCharsets.UTF_8, ptyConfig, env);
    }

    public ChannelExec createExecChannel(String var1, Charset var2, PtyChannelConfigurationHolder var3, Map<String, ?> var4) throws IOException;

    public ChannelExec createExecChannel(byte[] var1, PtyChannelConfigurationHolder var2, Map<String, ?> var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String executeRemoteCommand(String command) throws IOException {
        try (ByteArrayOutputStream stderr = new ByteArrayOutputStream();){
            String string;
            block9: {
                try {
                    string = this.executeRemoteCommand(command, stderr, StandardCharsets.US_ASCII);
                    if (stderr.size() <= 0) break block9;
                }
                catch (Throwable throwable) {
                    if (stderr.size() > 0) {
                        String errorMessage = stderr.toString(StandardCharsets.US_ASCII.name());
                        throw new RemoteException("Error reported from remote command=" + command, new ServerException(errorMessage));
                    }
                    throw throwable;
                }
                String errorMessage = stderr.toString(StandardCharsets.US_ASCII.name());
                throw new RemoteException("Error reported from remote command=" + command, new ServerException(errorMessage));
            }
            return string;
        }
    }

    default public String executeRemoteCommand(String command, OutputStream stderr, Charset charset) throws IOException {
        if (charset == null) {
            charset = StandardCharsets.US_ASCII;
        }
        try (ByteArrayOutputStream stdout = new ByteArrayOutputStream(127);){
            this.executeRemoteCommand(command, stdout, stderr, charset);
            byte[] outBytes = stdout.toByteArray();
            String string = new String(outBytes, charset);
            return string;
        }
    }

    default public void executeRemoteCommand(String command, OutputStream stdout, OutputStream stderr, Charset charset) throws IOException {
        if (charset == null) {
            charset = StandardCharsets.US_ASCII;
        }
        try (OutputStream channelErr = stderr == null ? new NullOutputStream() : new NoCloseOutputStream(stderr);
             OutputStream channelOut = stdout == null ? new NullOutputStream() : new NoCloseOutputStream(stdout);
             ChannelExec channel = this.createExecChannel(command, charset, null, Collections.emptyMap());){
            channel.setOut(channelOut);
            channel.setErr(channelErr);
            channel.open().await();
            Set<ClientChannelEvent> waitMask = channel.waitFor(REMOTE_COMMAND_WAIT_EVENTS, 0L);
            if (waitMask.contains((Object)ClientChannelEvent.TIMEOUT)) {
                throw new SocketTimeoutException("Failed to retrieve command result in time: " + command);
            }
            Integer exitStatus = channel.getExitStatus();
            ClientChannel.validateCommandExitStatusCode(command, exitStatus);
        }
    }

    public ChannelSubsystem createSubsystemChannel(String var1) throws IOException;

    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress var1, SshdSocketAddress var2) throws IOException;

    default public ExplicitPortForwardingTracker createLocalPortForwardingTracker(int localPort, SshdSocketAddress remote) throws IOException {
        return this.createLocalPortForwardingTracker(new SshdSocketAddress(localPort), remote);
    }

    default public ExplicitPortForwardingTracker createLocalPortForwardingTracker(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        return new ExplicitPortForwardingTracker(this, true, local, remote, this.startLocalPortForwarding(local, remote));
    }

    default public ExplicitPortForwardingTracker createRemotePortForwardingTracker(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        return new ExplicitPortForwardingTracker(this, false, local, remote, this.startRemotePortForwarding(remote, local));
    }

    default public DynamicPortForwardingTracker createDynamicPortForwardingTracker(SshdSocketAddress local) throws IOException {
        return new DynamicPortForwardingTracker(this, local, this.startDynamicPortForwarding(local));
    }

    public Set<ClientSessionEvent> getSessionState();

    public Set<ClientSessionEvent> waitFor(Collection<ClientSessionEvent> var1, long var2);

    default public Set<ClientSessionEvent> waitFor(Collection<ClientSessionEvent> mask, Duration timeout) {
        return this.waitFor(mask, timeout != null ? timeout.toMillis() : -1L);
    }

    public Map<Object, Object> getMetadataMap();

    @Override
    public ClientFactoryManager getFactoryManager();

    public KeyExchangeFuture switchToNoneCipher() throws IOException;

    public static KeyIdentityProvider providerOf(ClientSession session) {
        return session == null ? KeyIdentityProvider.EMPTY_KEYS_PROVIDER : KeyIdentityProvider.resolveKeyIdentityProvider(session.getRegisteredIdentities(), session.getKeyIdentityProvider());
    }

    public static Iterator<String> passwordIteratorOf(ClientSession session) throws IOException, GeneralSecurityException {
        return session == null ? Collections.emptyIterator() : PasswordIdentityProvider.iteratorOf(session, session.getRegisteredIdentities(), session.getPasswordIdentityProvider());
    }

    public static enum ClientSessionEvent {
        TIMEOUT,
        CLOSED,
        WAIT_AUTH,
        AUTHED;

    }
}

