/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.impl;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.OpenSshCertificate;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.keys.OpenSSHCertPublicKeyParser;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class OpenSSHCertificateDecoder
extends AbstractPublicKeyEntryDecoder<OpenSshCertificate, OpenSshCertificate> {
    public static final OpenSSHCertificateDecoder INSTANCE = new OpenSSHCertificateDecoder();

    public OpenSSHCertificateDecoder() {
        super(OpenSshCertificate.class, OpenSshCertificate.class, Collections.unmodifiableList(Arrays.asList("rsa-sha2-256-cert-v01@openssh.com", "rsa-sha2-512-cert-v01@openssh.com", "ssh-rsa-cert-v01@openssh.com", "ssh-dss-cert-v01@openssh.com", "ssh-ed25519-cert-v01@openssh.com", "ecdsa-sha2-nistp256-cert-v01@openssh.com", "ecdsa-sha2-nistp384-cert-v01@openssh.com", "ecdsa-sha2-nistp521-cert-v01@openssh.com")));
    }

    @Override
    public OpenSshCertificate decodePublicKey(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putString(keyType);
        buffer.putRawBytes(IoUtils.toByteArray(keyData));
        buffer.getString();
        OpenSshCertificate cert = OpenSSHCertPublicKeyParser.INSTANCE.getRawPublicKey(keyType, buffer);
        return cert;
    }

    @Override
    public String encodePublicKey(OutputStream s, OpenSshCertificate key) throws IOException {
        Objects.requireNonNull(key, "No public key provided");
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putRawPublicKey(key);
        s.write(buffer.getCompactData());
        return key.getKeyType();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenSshCertificate clonePublicKey(OpenSshCertificate key) throws GeneralSecurityException {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            PublicKey publicKey;
            String keyType = this.encodePublicKey((OutputStream)outStream, key);
            try (ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());){
                publicKey = this.decodePublicKey((SessionContext)null, keyType, (InputStream)inStream, (Map)null);
            }
            return publicKey;
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Unable to clone key ID=" + key.getId(), e);
        }
    }

    @Override
    public OpenSshCertificate clonePrivateKey(OpenSshCertificate key) throws GeneralSecurityException {
        return this.clonePublicKey(key);
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return null;
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return null;
    }
}

