/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.security;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;

public class SunJCESecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    private final Map<String, String> defaultProperties = new HashMap<String, String>();

    public SunJCESecurityProviderRegistrar() {
        super("SunJCEWrapper");
        String baseName = this.getBasePropertyName();
        this.defaultProperties.put(baseName + ".Cipher", "AES");
        this.defaultProperties.put(baseName + ".Mac", "HmacSha1,HmacSha224,HmacSha256,HmacSha384,HmacSha512");
    }

    @Override
    public boolean isEnabled() {
        if (SecurityUtils.isFipsMode() || !super.isEnabled()) {
            return false;
        }
        return this.isSupported();
    }

    @Override
    public String getProviderName() {
        return "SunJCE";
    }

    @Override
    public String getDefaultSecurityEntitySupportValue(Class<?> entityType) {
        return "";
    }

    @Override
    public String getString(String name) {
        String byDefault;
        String configured = super.getString(name);
        if (GenericUtils.isEmpty(configured) && (byDefault = this.defaultProperties.get(name)) != null) {
            return byDefault;
        }
        return configured;
    }

    @Override
    public boolean isNamedProviderUsed() {
        return false;
    }

    @Override
    public Provider getSecurityProvider() {
        return Security.getProvider(this.getProviderName());
    }

    @Override
    public boolean isSupported() {
        return this.getSecurityProvider() != null;
    }
}

