/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.file.root;

import io.jenkins.cli.shaded.org.apache.sshd.common.file.root.RootedDirectoryStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.file.root.RootedFileSystem;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Set;

public class RootedSecureDirectoryStream
extends RootedDirectoryStream
implements SecureDirectoryStream<Path> {
    public RootedSecureDirectoryStream(RootedFileSystem rfs, SecureDirectoryStream<Path> delegate) {
        super(rfs, delegate);
    }

    @Override
    public SecureDirectoryStream<Path> newDirectoryStream(Path path, LinkOption ... options) throws IOException {
        return new RootedSecureDirectoryStream(this.rfs, this.delegate().newDirectoryStream(this.fixPath(path), options));
    }

    protected Path fixPath(Path p) {
        if (p.isAbsolute()) {
            return this.rfs.provider().unroot(p);
        }
        return this.rfs.getRootFileSystem().getPath(p.toString(), new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.delegate().newByteChannel(this.fixPath(path), options, attrs);
    }

    @Override
    public void deleteFile(Path path) throws IOException {
        this.delegate().deleteFile(this.fixPath(path));
    }

    @Override
    public void deleteDirectory(Path path) throws IOException {
        this.delegate().deleteDirectory(this.fixPath(path));
    }

    @Override
    public void move(Path srcpath, SecureDirectoryStream<Path> targetdir, Path targetpath) throws IOException {
        this.delegate().move(this.fixPath(srcpath), targetdir, targetpath);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> type) {
        return this.delegate().getFileAttributeView(type);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return this.delegate().getFileAttributeView(path, type, options);
    }

    private SecureDirectoryStream<Path> delegate() {
        return (SecureDirectoryStream)this.delegate;
    }
}

