/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.core;

import io.jenkins.cli.shaded.jakarta.websocket.CloseReason;
import java.io.UnsupportedEncodingException;

public enum CloseReasons {
    NORMAL_CLOSURE(CloseReason.CloseCodes.NORMAL_CLOSURE, "Normal closure."),
    GOING_AWAY(CloseReason.CloseCodes.GOING_AWAY, "Going away."),
    PROTOCOL_ERROR(CloseReason.CloseCodes.PROTOCOL_ERROR, "Protocol error."),
    CANNOT_ACCEPT(CloseReason.CloseCodes.CANNOT_ACCEPT, "Cannot accept."),
    RESERVED(CloseReason.CloseCodes.RESERVED, "Reserved."),
    NO_STATUS_CODE(CloseReason.CloseCodes.NO_STATUS_CODE, "No status code."),
    CLOSED_ABNORMALLY(CloseReason.CloseCodes.CLOSED_ABNORMALLY, "Closed abnormally."),
    NOT_CONSISTENT(CloseReason.CloseCodes.NOT_CONSISTENT, "Not consistent."),
    VIOLATED_POLICY(CloseReason.CloseCodes.VIOLATED_POLICY, "Violated policy."),
    TOO_BIG(CloseReason.CloseCodes.TOO_BIG, "Too big."),
    NO_EXTENSION(CloseReason.CloseCodes.NO_EXTENSION, "No extension."),
    UNEXPECTED_CONDITION(CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Unexpected condition."),
    SERVICE_RESTART(CloseReason.CloseCodes.SERVICE_RESTART, "Service restart."),
    TRY_AGAIN_LATER(CloseReason.CloseCodes.TRY_AGAIN_LATER, "Try again later."),
    TLS_HANDSHAKE_FAILURE(CloseReason.CloseCodes.TLS_HANDSHAKE_FAILURE, "TLS handshake failure.");

    private final CloseReason closeReason;

    private CloseReasons(CloseReason.CloseCode closeCode, String reasonPhrase) {
        this.closeReason = new CloseReason(closeCode, reasonPhrase);
    }

    public CloseReason getCloseReason() {
        return this.closeReason;
    }

    public static CloseReason create(CloseReason.CloseCode closeCode, String reasonPhrase) {
        return new CloseReason(closeCode, CloseReasons.trimTo123Bytes(reasonPhrase));
    }

    private static String trimTo123Bytes(String reasonPhrase) {
        try {
            byte[] bytes;
            return reasonPhrase == null ? reasonPhrase : ((bytes = reasonPhrase.getBytes("UTF-8")).length <= 123 ? reasonPhrase : new String(CloseReasons.trimTo123Bytes(bytes), "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee);
        }
    }

    private static byte[] trimTo123Bytes(byte[] bytes) {
        byte[] newBytes = new byte[123];
        System.arraycopy(bytes, 0, newBytes, 0, 120);
        newBytes[122] = 46;
        newBytes[121] = 46;
        newBytes[120] = 46;
        return newBytes;
    }
}

