/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.jvnet.localizer;

import io.jenkins.cli.shaded.org.jvnet.localizer.LocaleProvider;
import io.jenkins.cli.shaded.org.jvnet.localizer.ResourceBundleHolder;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;

public class Localizable
implements Serializable {
    private final ResourceBundleHolder holder;
    private final String key;
    private final Serializable[] args;

    public Localizable(ResourceBundleHolder holder, String key, Object ... args) {
        this.holder = holder;
        this.key = key;
        this.args = new Serializable[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.args[i] = args[i] instanceof Serializable ? (Serializable)args[i] : String.valueOf(args[i]);
        }
    }

    public String getKey() {
        return this.key;
    }

    public String toString(Locale locale) {
        try {
            return MessageFormat.format(this.holder.get(locale).getString(this.key), this.args);
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("Failed to localize key=" + this.key + ",args=" + Arrays.asList(this.args), e);
        }
    }

    public String toString() {
        return this.toString(LocaleProvider.getLocale());
    }
}

