/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKdfOptions;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.util.function.Predicate;

public class OpenSSHParserContext {
    public static final String NONE_CIPHER = "none";
    public static final Predicate<String> IS_NONE_CIPHER = c -> GenericUtils.isEmpty(c) || NONE_CIPHER.equalsIgnoreCase((String)c);
    private String cipherName;
    private OpenSSHKdfOptions kdfOptions;

    public OpenSSHParserContext() {
    }

    public OpenSSHParserContext(String cipherName, OpenSSHKdfOptions kdfOptions) {
        this.setCipherName(cipherName);
        this.setKdfOptions(kdfOptions);
    }

    public boolean isEncrypted() {
        if (!IS_NONE_CIPHER.test(this.getCipherName())) {
            return true;
        }
        OpenSSHKdfOptions options = this.getKdfOptions();
        return options != null && options.isEncrypted();
    }

    public String getCipherName() {
        return this.cipherName;
    }

    public void setCipherName(String cipherName) {
        this.cipherName = cipherName;
    }

    public OpenSSHKdfOptions getKdfOptions() {
        return this.kdfOptions;
    }

    public void setKdfOptions(OpenSSHKdfOptions kdfOptions) {
        this.kdfOptions = kdfOptions;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[cipher=" + this.getCipherName() + ", kdfOptions=" + this.getKdfOptions() + "]";
    }
}

