/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.keys;

import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentityLoader;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentityLoaderHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProviderHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class LazyClientKeyIdentityProvider
implements KeyIdentityProvider,
ClientIdentityLoaderHolder,
FilePasswordProviderHolder {
    private final ClientIdentityLoader clientIdentityLoader;
    private final Collection<? extends NamedResource> locations;
    private final FilePasswordProvider passwordProvider;
    private final boolean ignoreNonExisting;

    public LazyClientKeyIdentityProvider(ClientIdentityLoader loader, Collection<? extends NamedResource> locations, FilePasswordProvider passwordProvider, boolean ignoreNonExisting) {
        this.clientIdentityLoader = Objects.requireNonNull(loader, "No client identity loader provided");
        this.locations = locations;
        this.passwordProvider = passwordProvider;
        this.ignoreNonExisting = ignoreNonExisting;
    }

    @Override
    public ClientIdentityLoader getClientIdentityLoader() {
        return this.clientIdentityLoader;
    }

    public Collection<? extends NamedResource> getLocations() {
        return this.locations;
    }

    @Override
    public FilePasswordProvider getFilePasswordProvider() {
        return this.passwordProvider;
    }

    public boolean isIgnoreNonExisting() {
        return this.ignoreNonExisting;
    }

    @Override
    public Iterable<KeyPair> loadKeys(final SessionContext session) throws IOException, GeneralSecurityException {
        final Collection<? extends NamedResource> locs = this.getLocations();
        if (GenericUtils.isEmpty(locs)) {
            return Collections.emptyList();
        }
        return () -> new Iterator<KeyPair>(){
            private KeyPair currentPair;
            private boolean finished;
            private final Iterator iter;
            private Iterator currentIdentities;
            {
                this.iter = locs.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                this.currentPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
                if (this.currentPair != null) {
                    return true;
                }
                while (this.iter.hasNext()) {
                    Iterable<KeyPair> ids;
                    NamedResource l = (NamedResource)this.iter.next();
                    try {
                        ids = LazyClientKeyIdentityProvider.this.loadClientIdentities(session, l);
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new IllegalStateException("Failed (" + e.getClass().getSimpleName() + ") to load key from " + l.getName() + ": " + e.getMessage(), e);
                    }
                    this.currentIdentities = ids == null ? null : ids.iterator();
                    this.currentPair = KeyIdentityProvider.exhaustCurrentIdentities(this.currentIdentities);
                    if (this.currentPair == null) continue;
                    return true;
                }
                this.finished = true;
                return false;
            }

            @Override
            public KeyPair next() {
                if (this.finished) {
                    throw new NoSuchElementException("All identities have been exhausted");
                }
                if (this.currentPair == null) {
                    throw new IllegalStateException("'next()' called without asking 'hasNext()'");
                }
                KeyPair kp = this.currentPair;
                this.currentPair = null;
                return kp;
            }

            public String toString() {
                return Iterator.class.getSimpleName() + "[" + LazyClientKeyIdentityProvider.class.getSimpleName() + "]";
            }
        };
    }

    protected Iterable<KeyPair> loadClientIdentities(SessionContext session, NamedResource location) throws IOException, GeneralSecurityException {
        ClientIdentityLoader loader = this.getClientIdentityLoader();
        boolean ignoreInvalid = this.isIgnoreNonExisting();
        try {
            if (!loader.isValidLocation(location)) {
                if (ignoreInvalid) {
                    return null;
                }
                throw new FileNotFoundException("Invalid identity location: " + location.getName());
            }
        }
        catch (IOException e) {
            if (ignoreInvalid) {
                return null;
            }
            throw e;
        }
        return loader.loadClientIdentities(session, location, this.getFilePasswordProvider());
    }
}

