/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.io.Serializable;

public class VersionInfo
implements Serializable,
Comparable<VersionInfo> {
    private static final long serialVersionUID = -9127482432228413836L;
    private final int majorVersion;
    private final int minorVersion;
    private final int release;
    private final int buildNumber;

    public VersionInfo(int major, int minor) {
        this(major, minor, 0, 0);
    }

    public VersionInfo(int major, int minor, int release, int build) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.release = release;
        this.buildNumber = build;
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public final int getRelease() {
        return this.release;
    }

    public final int getBuildNumber() {
        return this.buildNumber;
    }

    public int hashCode() {
        return NumberUtils.hashCode(this.getMajorVersion(), this.getMinorVersion(), this.getRelease(), this.getBuildNumber());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((VersionInfo)obj) == 0;
    }

    @Override
    public int compareTo(VersionInfo o) {
        if (o == null) {
            return -1;
        }
        if (o == this) {
            return 0;
        }
        int nRes = Integer.compare(this.getMajorVersion(), o.getMajorVersion());
        if (nRes == 0) {
            nRes = Integer.compare(this.getMinorVersion(), o.getMinorVersion());
        }
        if (nRes == 0) {
            nRes = Integer.compare(this.getRelease(), o.getRelease());
        }
        if (nRes == 0) {
            nRes = Integer.compare(this.getBuildNumber(), o.getBuildNumber());
        }
        return nRes;
    }

    public String toString() {
        return NumberUtils.join('.', this.getMajorVersion(), this.getMinorVersion(), this.getRelease(), this.getBuildNumber());
    }

    public static VersionInfo parse(String version) throws NumberFormatException {
        String[] comps = GenericUtils.split(version, '.');
        if (GenericUtils.isEmpty(comps)) {
            return null;
        }
        int[] values = new int[4];
        int maxValues = Math.min(comps.length, values.length);
        for (int index = 0; index < maxValues; ++index) {
            String c = comps[index];
            int v = Integer.parseInt(c);
            ValidateUtils.checkTrue(v >= 0, "Invalid version component in %s", (Object)version);
            values[index] = v;
        }
        return new VersionInfo(values[0], values[1], values[2], values[3]);
    }
}

