/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.AbstractDH;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.DHFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KexProposalOption;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KeyExchange;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KeyExchangeFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.Signature;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.server.kex.AbstractDHServerKeyExchange;
import io.jenkins.cli.shaded.org.apache.sshd.server.session.ServerSession;
import java.security.KeyPair;
import java.util.Objects;

public class DHGServer
extends AbstractDHServerKeyExchange {
    protected final DHFactory factory;
    protected AbstractDH dh;

    protected DHGServer(DHFactory factory, Session session) {
        super(session);
        this.factory = Objects.requireNonNull(factory, "No factory");
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(final DHFactory factory) {
        return new KeyExchangeFactory(){

            @Override
            public KeyExchange createKeyExchange(Session session) throws Exception {
                return new DHGServer(factory, session);
            }

            @Override
            public String getName() {
                return factory.getName();
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        super.init(v_s, v_c, i_s, i_c);
        this.dh = this.factory.create(new Object[0]);
        this.hash = this.dh.getHash();
        this.hash.init();
        this.setF(this.dh.getE());
    }

    @Override
    public boolean next(int cmd, Buffer buffer) throws Exception {
        ServerSession session = this.getServerSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] process command={}", this, session, KeyExchange.getSimpleKexOpcodeName(cmd));
        }
        if (cmd != 30) {
            throw new SshException(3, "Protocol error: expected packet SSH_MSG_KEXDH_INIT, got " + KeyExchange.getSimpleKexOpcodeName(cmd));
        }
        byte[] e = this.updateE(buffer);
        this.dh.setF(e);
        this.k = this.dh.getK();
        KeyPair kp = Objects.requireNonNull(session.getHostKey(), "No server key pair available");
        String algo = session.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
        Signature sig = ValidateUtils.checkNotNull(NamedFactory.create(session.getSignatureFactories(), algo), "Unknown negotiated server keys: %s", (Object)algo);
        sig.initSigner(session, kp.getPrivate());
        buffer = new ByteArrayBuffer();
        buffer.putRawPublicKey(kp.getPublic());
        byte[] k_s = buffer.getCompactData();
        buffer.clear();
        buffer.putBytes(this.v_c);
        buffer.putBytes(this.v_s);
        buffer.putBytes(this.i_c);
        buffer.putBytes(this.i_s);
        buffer.putBytes(k_s);
        this.dh.putE(buffer, e);
        byte[] f = this.getF();
        this.dh.putF(buffer, f);
        buffer.putMPInt(this.k);
        this.hash.update(buffer.array(), 0, buffer.available());
        this.h = this.hash.digest();
        sig.update(session, this.h);
        buffer.clear();
        buffer.putString(sig.getSshAlgorithmName(algo));
        byte[] sigBytes = sig.sign(session);
        buffer.putBytes(sigBytes);
        byte[] sigH = buffer.getCompactData();
        if (this.log.isTraceEnabled()) {
            this.log.trace("next({})[{}][K_S]:  {}", this, session, BufferUtils.toHex(k_s));
            this.log.trace("next({})[{}][f]:    {}", this, session, BufferUtils.toHex(f));
            this.log.trace("next({})[{}][sigH]: {}", this, session, BufferUtils.toHex(sigH));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("next({})[{}] Send SSH_MSG_KEXDH_REPLY", (Object)this, (Object)session);
        }
        buffer = session.prepareBuffer((byte)31, BufferUtils.clear(buffer));
        buffer.putBytes(k_s);
        this.dh.putF(buffer, f);
        buffer.putBytes(sigH);
        session.writePacket(buffer);
        return true;
    }
}

