/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey;

import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgent;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.AbstractKeyPairIterator;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class SshAgentPublicKeyIterator
extends AbstractKeyPairIterator<KeyAgentIdentity> {
    private final SshAgent agent;
    private final Iterator<? extends Map.Entry<PublicKey, String>> keys;

    public SshAgentPublicKeyIterator(ClientSession session, SshAgent agent) throws IOException {
        super(session);
        this.agent = Objects.requireNonNull(agent, "No agent");
        this.keys = GenericUtils.iteratorOf(agent.getIdentities());
    }

    @Override
    public boolean hasNext() {
        return this.keys != null && this.keys.hasNext();
    }

    @Override
    public KeyAgentIdentity next() {
        Map.Entry<PublicKey, String> kp = this.keys.next();
        return new KeyAgentIdentity(this.agent, kp.getKey(), kp.getValue());
    }
}

