/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey;

import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.Signature;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.SignatureFactoriesHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.SignatureFactoriesManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.SignatureFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeyPairIdentity
implements PublicKeyIdentity,
SignatureFactoriesHolder {
    private final KeyPair pair;
    private final List<NamedFactory<Signature>> signatureFactories;

    public KeyPairIdentity(SignatureFactoriesManager primary, SignatureFactoriesManager secondary, KeyPair pair) {
        this.signatureFactories = Collections.unmodifiableList(ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(primary, secondary), "No available signature factories", new Object[0]));
        this.pair = Objects.requireNonNull(pair, "No key pair");
    }

    @Override
    public KeyPair getKeyIdentity() {
        return this.pair;
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.signatureFactories;
    }

    @Override
    public Map.Entry<String, byte[]> sign(SessionContext session, String algo, byte[] data) throws Exception {
        NamedFactory<Signature> factory;
        if (GenericUtils.isEmpty(algo)) {
            KeyPair kp = this.getKeyIdentity();
            algo = KeyUtils.getKeyType(kp.getPublic());
            factory = SignatureFactory.resolveSignatureFactory(algo, this.getSignatureFactories());
        } else {
            factory = NamedResource.findByName(algo, String.CASE_INSENSITIVE_ORDER, this.getSignatureFactories());
        }
        Signature verifier = factory == null ? null : (Signature)factory.create();
        ValidateUtils.checkNotNull(verifier, "No signer could be located for key type=%s", (Object)algo);
        verifier.initSigner(session, this.pair.getPrivate());
        verifier.update(session, data);
        byte[] signature = verifier.sign(session);
        return new AbstractMap.SimpleImmutableEntry<String, byte[]>(factory.getName(), signature);
    }

    public String toString() {
        KeyPair kp = this.getKeyIdentity();
        PublicKey pubKey = kp.getPublic();
        return this.getClass().getSimpleName() + " type=" + KeyUtils.getKeyType(pubKey) + ", factories=" + this.getSignatureFactoriesNameList() + ", fingerprint=" + KeyUtils.getFingerPrint(pubKey);
    }
}

