/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts;

import io.jenkins.cli.shaded.org.apache.sshd.common.Factory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.mac.BuiltinMacs;
import io.jenkins.cli.shaded.org.apache.sshd.common.mac.Mac;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public enum KnownHostDigest implements NamedFactory<Mac>
{
    SHA1("1", BuiltinMacs.hmacsha1);

    public static final Set<KnownHostDigest> VALUES;
    private final String name;
    private final Factory<Mac> factory;

    private KnownHostDigest(String name, Factory<Mac> factory) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No name");
        this.factory = Objects.requireNonNull(factory, "No factory");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Mac create() {
        return this.factory.create();
    }

    public static KnownHostDigest fromName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(KnownHostDigest.class));
    }
}

