/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.file.util;

import io.jenkins.cli.shaded.org.apache.sshd.common.file.util.MockFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Iterator;

public class MockPath
implements Path {
    private final String path;
    private final FileSystem fs;

    public MockPath(String path) {
        this.path = path;
        this.fs = new MockFileSystem(path);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public Path getRoot() {
        return this;
    }

    @Override
    public Path getFileName() {
        return this;
    }

    @Override
    public Path getParent() {
        return null;
    }

    @Override
    public int getNameCount() {
        return 0;
    }

    @Override
    public Path getName(int index) {
        if (index == 0) {
            return this;
        }
        throw new IllegalArgumentException("getName - bad index: " + index);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        throw new UnsupportedOperationException("subPath(" + beginIndex + "," + endIndex + ") N/A");
    }

    @Override
    public boolean startsWith(Path other) {
        return this.startsWith(other.toString());
    }

    @Override
    public boolean startsWith(String other) {
        return this.path.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        return this.endsWith(other.toString());
    }

    @Override
    public boolean endsWith(String other) {
        return this.path.endsWith(other);
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path resolve(Path other) {
        return this.resolve(other.toString());
    }

    @Override
    public Path resolve(String other) {
        throw new UnsupportedOperationException("resolve(" + other + ") N/A");
    }

    @Override
    public Path resolveSibling(Path other) {
        return this.resolveSibling(other.toString());
    }

    @Override
    public Path resolveSibling(String other) {
        throw new UnsupportedOperationException("resolveSibling(" + other + ") N/A");
    }

    @Override
    public Path relativize(Path other) {
        throw new UnsupportedOperationException("relativize(" + other + ") N/A");
    }

    @Override
    public URI toUri() {
        throw new UnsupportedOperationException("toUri() N/A");
    }

    @Override
    public Path toAbsolutePath() {
        return this;
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("toFile() N/A");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, (WatchEvent.Modifier[])null);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new IOException("register(" + this.path + ") N/A");
    }

    @Override
    public Iterator<Path> iterator() {
        return Collections.singleton(this).iterator();
    }

    @Override
    public int compareTo(Path other) {
        return this.path.compareTo(other.toString());
    }

    @Override
    public String toString() {
        return this.path;
    }
}

