/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.x11;

import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CancelOption;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoAcceptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoServiceFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.OsUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.Readable;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import io.jenkins.cli.shaded.org.apache.sshd.core.CoreModuleProperties;
import io.jenkins.cli.shaded.org.apache.sshd.server.x11.ChannelForwardedX11;
import io.jenkins.cli.shaded.org.apache.sshd.server.x11.X11ForwardSupport;
import io.jenkins.cli.shaded.org.apache.sshd.server.x11.X11ForwardingExceptionMarker;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;

public class DefaultX11ForwardSupport
extends AbstractInnerCloseable
implements X11ForwardSupport {
    private final ConnectionService service;
    private IoAcceptor acceptor;

    public DefaultX11ForwardSupport(ConnectionService service) {
        this.service = Objects.requireNonNull(service, "No connection service");
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(this.acceptor).build();
    }

    @Override
    public synchronized String createDisplay(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.isClosed()) {
            throw new IllegalStateException("X11ForwardSupport is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("X11ForwardSupport is closing");
        }
        if (OsUtils.isWin32()) {
            if (debugEnabled) {
                this.log.debug("createDisplay(auth={}, cookie={}, screen={}) Windows O/S N/A", authenticationProtocol, authenticationCookie, screen);
            }
            return null;
        }
        Session session = (Session)Objects.requireNonNull(this.service.getSession(), "No session");
        if (this.acceptor == null) {
            FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
            IoServiceFactory factory = Objects.requireNonNull(manager.getIoServiceFactory(), "No I/O service factory");
            this.acceptor = factory.createAcceptor(this);
        }
        int minDisplayNumber = CoreModuleProperties.X11_DISPLAY_OFFSET.getRequired(session);
        int maxDisplayNumber = CoreModuleProperties.X11_MAX_DISPLAYS.getRequired(session);
        int basePort = CoreModuleProperties.X11_BASE_PORT.getRequired(session);
        String bindHost = CoreModuleProperties.X11_BIND_HOST.getRequired(session);
        InetSocketAddress addr = null;
        for (int displayNumber = minDisplayNumber; displayNumber < maxDisplayNumber; ++displayNumber) {
            int port = basePort + displayNumber;
            addr = new InetSocketAddress(bindHost, port);
            try {
                this.acceptor.bind(addr);
                break;
            }
            catch (BindException bindErr) {
                if (debugEnabled) {
                    this.log.debug("createDisplay(auth={}, cookie={}, screen={}) failed ({}) to bind to address={}: {}", authenticationProtocol, authenticationCookie, screen, bindErr.getClass().getSimpleName(), addr, bindErr.getMessage());
                }
                addr = null;
                continue;
            }
        }
        if (addr == null) {
            this.log.warn("createDisplay(auth={}, cookie={}, screen={}) failed to allocate internet-domain X11 display socket in range {}-{}", authenticationProtocol, authenticationCookie, screen, minDisplayNumber, maxDisplayNumber);
            Set<SocketAddress> boundAddresses = this.acceptor.getBoundAddresses();
            if (GenericUtils.isEmpty(boundAddresses)) {
                if (debugEnabled) {
                    this.log.debug("createDisplay(auth={}, cookie={}, screen={}) closing - no more bound addresses", authenticationProtocol, authenticationCookie, screen);
                }
                this.close();
            } else if (debugEnabled) {
                this.log.debug("createDisplay(auth={}, cookie={}, screen={}) closing - remaining bound addresses: {}", authenticationProtocol, authenticationCookie, screen, boundAddresses);
            }
            return null;
        }
        int port = addr.getPort();
        int displayNumber = port - basePort;
        String authDisplay = "unix:" + displayNumber + "." + screen;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(XAUTH_COMMAND, "remove", authDisplay);
            Process p = processBuilder.start();
            int result = p.waitFor();
            if (debugEnabled) {
                this.log.debug("createDisplay({}) {} remove result={}", authDisplay, XAUTH_COMMAND, result);
            }
            if (result == 0) {
                processBuilder = new ProcessBuilder(XAUTH_COMMAND, "add", authDisplay, authenticationProtocol, authenticationCookie);
                p = processBuilder.start();
                result = p.waitFor();
                if (debugEnabled) {
                    this.log.debug("createDisplay({}) {} add result={}", authDisplay, XAUTH_COMMAND, result);
                }
            }
            if (result != 0) {
                throw new IllegalStateException("Bad " + XAUTH_COMMAND + " invocation result: " + result);
            }
            return bindHost + ":" + displayNumber + "." + screen;
        }
        catch (Throwable e) {
            this.warn("createDisplay({}) failed ({}) run xauth: {}", authDisplay, e.getClass().getSimpleName(), e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        ChannelForwardedX11 channel = new ChannelForwardedX11(session);
        session.setAttribute(ChannelForwardedX11.class, channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sessionCreated({}) channel{}", (Object)session, (Object)channel);
        }
        this.service.registerChannel(channel);
        Duration openTimeout = CoreModuleProperties.X11_OPEN_TIMEOUT.getRequired(channel);
        channel.open().verify(openTimeout, new CancelOption[0]);
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.removeAttribute(ChannelForwardedX11.class);
        Throwable cause = (Throwable)session.removeAttribute(X11ForwardingExceptionMarker.class);
        if (channel != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionClosed({}) close channel={} - cause={}", session, channel, cause == null ? null : cause.getClass().getSimpleName());
            }
            channel.close(cause != null);
        }
    }

    @Override
    public void messageReceived(IoSession session, Readable message) throws Exception {
        ChannelForwardedX11 channel = (ChannelForwardedX11)session.getAttribute(ChannelForwardedX11.class);
        ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
        buffer.putBuffer(message);
        if (this.log.isTraceEnabled()) {
            this.log.trace("messageReceived({}) channel={}, len={}", session, channel, buffer.available());
        }
        OutputStream outputStream = channel.getInvertedIn();
        outputStream.write(((Buffer)buffer).array(), ((Buffer)buffer).rpos(), buffer.available());
        outputStream.flush();
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        session.setAttribute(X11ForwardingExceptionMarker.class, cause);
        this.log.debug("exceptionCaught({}) {}: {}", session, cause.getClass().getSimpleName(), cause.getMessage(), cause);
        session.close(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.service.getClass();
    }
}

