/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.channel;

import io.jenkins.cli.shaded.org.apache.sshd.common.SshConstants;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Channel;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.IoWriteFutureImpl;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.RemoteWindow;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.throttle.ChannelStreamWriter;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CloseFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.WritePendingException;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.AbstractCloseable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;

public class ChannelAsyncOutputStream
extends AbstractCloseable
implements IoOutputStream,
ChannelHolder {
    protected final WriteState writeState = new WriteState();
    private final Channel channelInstance;
    private final ChannelStreamWriter packetWriter;
    private final byte cmd;
    private final Object packetWriteId;

    public ChannelAsyncOutputStream(Channel channel, byte cmd) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel");
        this.packetWriter = this.channelInstance.resolveChannelStreamWriter(channel, cmd);
        this.cmd = cmd;
        this.packetWriteId = channel.toString() + "[" + SshConstants.getCommandMessageName(cmd) + "]";
    }

    @Override
    public Channel getChannel() {
        return this.channelInstance;
    }

    public byte getCommandType() {
        return this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            throw new EOFException("Closing: " + this.writeState);
        }
        IoWriteFutureImpl future = new IoWriteFutureImpl(this.packetWriteId, buffer);
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            if (!AbstractCloseable.State.Opened.equals((Object)this.writeState.openState)) {
                throw new EOFException("Closing: " + this.writeState);
            }
            if (this.writeState.writeInProgress) {
                throw new WritePendingException("A write operation is already pending; cannot write " + buffer.available() + " bytes");
            }
            this.writeState.toSend = this.writeState.totalLength = buffer.available();
            this.writeState.lastWrite = future;
            this.writeState.pendingWrite = future;
            this.writeState.writeInProgress = true;
        }
        this.doWriteIfPossible(false);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            this.writeState.openState = (AbstractCloseable.State)((Object)this.state.get());
        }
        super.preClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCloseImmediately() {
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            this.writeState.openState = (AbstractCloseable.State)((Object)this.state.get());
        }
        try {
            if (!(this.packetWriter instanceof Channel)) {
                try {
                    this.packetWriter.close();
                }
                catch (IOException e) {
                    this.error("doCloseImmediately({}) Failed ({}) to close packet writer: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
                }
            }
            super.doCloseImmediately();
        }
        finally {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        int notSent;
        int total;
        IoWriteFutureImpl current = null;
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            this.writeState.openState = AbstractCloseable.State.Closed;
            current = this.writeState.pendingWrite;
            this.writeState.pendingWrite = null;
            total = this.writeState.totalLength;
            notSent = this.writeState.toSend;
        }
        if (current != null) {
            this.terminateFuture(current);
        }
        if (notSent > 0) {
            this.log.warn("doCloseImmediately({}): still have {} bytes of {} on closing channel", this, notSent, total);
        }
    }

    protected void terminateFuture(IoWriteFutureImpl future) {
        if (!future.isDone()) {
            if (future.getBuffer().available() > 0) {
                future.setValue(new EOFException("Channel closing"));
            } else {
                future.setValue(Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseFuture doCloseGracefully() {
        IoWriteFutureImpl current;
        IoWriteFuture last;
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            last = this.writeState.lastWrite;
            current = this.writeState.pendingWrite;
        }
        if (last == null) {
            return this.builder().build().close(false);
        }
        if (this.log.isDebugEnabled() && current instanceof BufferedFuture && ((BufferedFuture)current).waitOnWindow) {
            this.log.debug("doCloseGracefully({}): writing last data (waiting on window expansion)", (Object)this);
        }
        return this.builder().when(last).build().close(false);
    }

    public void onWindowExpanded() throws IOException {
        this.doWriteIfPossible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteIfPossible(boolean resume) {
        AbstractCloseable.State openState;
        IoWriteFutureImpl currentWrite = null;
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            this.writeState.windowExpanded |= resume;
            if (this.writeState.pendingWrite == null) {
                return;
            }
            openState = this.writeState.openState;
            currentWrite = this.writeState.pendingWrite;
            this.writeState.pendingWrite = null;
            this.writeState.windowExpanded = false;
        }
        while (currentWrite != null) {
            if (this.abortWrite(openState)) {
                this.terminateFuture(currentWrite);
                break;
            }
            IoWriteFutureImpl nextWrite = this.writePacket(currentWrite, resume);
            if (nextWrite == null) break;
            WriteState writeState2 = this.writeState;
            synchronized (writeState2) {
                openState = this.writeState.openState;
                if (this.writeState.windowExpanded) {
                    this.writeState.windowExpanded = false;
                    resume = true;
                    currentWrite = nextWrite;
                } else {
                    if (!this.abortWrite(openState)) {
                        this.writeState.pendingWrite = nextWrite;
                    } else {
                        this.writeState.writeInProgress = false;
                    }
                    currentWrite = null;
                }
            }
            if (currentWrite != null || !this.abortWrite(openState)) continue;
            this.terminateFuture(nextWrite);
            break;
        }
    }

    private boolean abortWrite(AbstractCloseable.State openState) {
        return AbstractCloseable.State.Immediate.equals((Object)openState) || AbstractCloseable.State.Closed.equals((Object)openState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFutureImpl writePacket(IoWriteFutureImpl future, boolean resume) {
        IoWriteFuture writeFuture;
        Buffer buffer = future.getBuffer();
        int stillToSend = buffer.available();
        if (stillToSend <= 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("writePacket({}) current buffer sent", (Object)this);
            }
            WriteState writeState = this.writeState;
            synchronized (writeState) {
                this.writeState.writeInProgress = false;
            }
            future.setValue(Boolean.TRUE);
            return null;
        }
        Channel channel = this.getChannel();
        RemoteWindow remoteWindow = channel.getRemoteWindow();
        long remoteWindowSize = remoteWindow.getSize();
        long packetSize = remoteWindow.getPacketSize();
        int chunkLength = (int)Math.min((long)stillToSend, Math.min(packetSize, remoteWindowSize));
        IoWriteFutureImpl f = future;
        if (chunkLength < stillToSend && !(f instanceof BufferedFuture)) {
            ByteArrayBuffer copied = new ByteArrayBuffer(stillToSend);
            ((Buffer)copied).putBuffer(buffer, false);
            f = new BufferedFuture(future.getId(), copied);
            f.addListener(w -> future.setValue(w.getException() != null ? w.getException() : Boolean.valueOf(w.isWritten())));
        }
        if (chunkLength <= 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("writePacket({})[resume={}] waiting for window space {}", this, resume, remoteWindowSize);
            }
            ((BufferedFuture)f).waitOnWindow = true;
            return f;
        }
        if (f instanceof BufferedFuture) {
            ((BufferedFuture)f).waitOnWindow = false;
        }
        buffer = f.getBuffer();
        if (this.log.isTraceEnabled()) {
            this.log.trace("writePacket({})[resume={}] attempting to write {} out of {}", this, resume, chunkLength, stillToSend);
        }
        if (chunkLength >= 0x7FFFFFF3) {
            IllegalArgumentException error = new IllegalArgumentException("Command " + SshConstants.getCommandMessageName(this.cmd) + " length (" + chunkLength + ") exceeds int boundaries");
            WriteState writeState = this.writeState;
            synchronized (writeState) {
                this.writeState.writeInProgress = false;
            }
            f.setValue(error);
            throw error;
        }
        remoteWindow.consume(chunkLength);
        try {
            writeFuture = this.packetWriter.writeData(this.createSendBuffer(buffer, channel, chunkLength));
        }
        catch (Throwable e) {
            WriteState writeState = this.writeState;
            synchronized (writeState) {
                this.writeState.writeInProgress = false;
            }
            f.setValue(e);
            return null;
        }
        IoWriteFutureImpl thisFuture = f;
        writeFuture.addListener(w -> this.onWritten(thisFuture, stillToSend, chunkLength, (IoWriteFuture)w));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onWritten(IoWriteFutureImpl future, int total, int length, IoWriteFuture f) {
        if (f.isWritten()) {
            if (total > length) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("onWritten({}) completed write of {} out of {}", this, length, total);
                }
                WriteState writeState = this.writeState;
                synchronized (writeState) {
                    this.writeState.toSend -= length;
                    this.writeState.pendingWrite = future;
                }
                this.doWriteIfPossible(false);
            } else {
                WriteState writeState = this.writeState;
                synchronized (writeState) {
                    this.writeState.toSend = 0;
                    this.writeState.pendingWrite = null;
                    this.writeState.writeInProgress = false;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("onWritten({}) completed write len={}", (Object)this, (Object)total);
                }
                future.setValue(Boolean.TRUE);
            }
        } else {
            Throwable reason = f.getException();
            this.debug("onWritten({}) failed ({}) to complete write of {} out of {}: {}", this, reason.getClass().getSimpleName(), length, total, reason.getMessage(), reason);
            WriteState writeState = this.writeState;
            synchronized (writeState) {
                this.writeState.pendingWrite = null;
                this.writeState.writeInProgress = false;
            }
            future.setValue(reason);
        }
    }

    protected Buffer createSendBuffer(Buffer buffer, Channel channel, int length) {
        SessionContext.validateSessionPayloadSize(length, "Invalid send buffer length: %d");
        Object s = channel.getSession();
        Buffer buf = s.createBuffer(this.cmd, length + 12);
        buf.putUInt(channel.getRecipient());
        if (this.cmd == 95) {
            buf.putUInt(1L);
        }
        buf.putUInt(length);
        buf.putRawBytes(buffer.array(), buffer.rpos(), length);
        buffer.rpos(buffer.rpos() + length);
        return buf;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "] cmd=" + SshConstants.getCommandMessageName(this.cmd & 0xFF);
    }

    protected static class WriteState {
        protected IoWriteFuture lastWrite;
        protected IoWriteFutureImpl pendingWrite;
        protected boolean writeInProgress;
        protected boolean windowExpanded;
        protected AbstractCloseable.State openState = AbstractCloseable.State.Opened;
        protected int totalLength;
        protected int toSend;

        protected WriteState() {
        }
    }

    protected static class BufferedFuture
    extends IoWriteFutureImpl {
        protected boolean waitOnWindow;

        BufferedFuture(Object id, Buffer buffer) {
            super(id, buffer);
        }
    }
}

