/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.mac;

import io.jenkins.cli.shaded.org.apache.sshd.common.mac.Mac;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import java.nio.BufferOverflowException;
import java.security.InvalidKeyException;
import java.util.Arrays;

public class Poly1305Mac
implements Mac {
    public static final int KEY_BYTES = 32;
    private static final int BLOCK_SIZE = 16;
    private int r0;
    private int r1;
    private int r2;
    private int r3;
    private int r4;
    private int s1;
    private int s2;
    private int s3;
    private int s4;
    private int k0;
    private int k1;
    private int k2;
    private int k3;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private final byte[] currentBlock = new byte[16];
    private int currentBlockOffset;

    @Override
    public String getAlgorithm() {
        return "Poly1305";
    }

    @Override
    public void init(byte[] key) throws Exception {
        if (NumberUtils.length(key) != 32) {
            throw new InvalidKeyException("Poly1305 key must be 32 bytes");
        }
        int t0 = Poly1305Mac.unpackIntLE(key, 0);
        int t1 = Poly1305Mac.unpackIntLE(key, 4);
        int t2 = Poly1305Mac.unpackIntLE(key, 8);
        int t3 = Poly1305Mac.unpackIntLE(key, 12);
        this.r0 = t0 & 0x3FFFFFF;
        this.r1 = (t0 >>> 26 | t1 << 6) & 0x3FFFF03;
        this.r2 = (t1 >>> 20 | t2 << 12) & 0x3FFC0FF;
        this.r3 = (t2 >>> 14 | t3 << 18) & 0x3F03FFF;
        this.r4 = t3 >>> 8 & 0xFFFFF;
        this.s1 = this.r1 * 5;
        this.s2 = this.r2 * 5;
        this.s3 = this.r3 * 5;
        this.s4 = this.r4 * 5;
        this.k0 = Poly1305Mac.unpackIntLE(key, 16);
        this.k1 = Poly1305Mac.unpackIntLE(key, 20);
        this.k2 = Poly1305Mac.unpackIntLE(key, 24);
        this.k3 = Poly1305Mac.unpackIntLE(key, 28);
    }

    @Override
    public void update(byte[] in, int offset, int length) {
        while (length > 0) {
            if (this.currentBlockOffset == 16) {
                this.processBlock();
            }
            int toCopy = Math.min(length, 16 - this.currentBlockOffset);
            System.arraycopy(in, offset, this.currentBlock, this.currentBlockOffset, toCopy);
            offset += toCopy;
            length -= toCopy;
            this.currentBlockOffset += toCopy;
        }
    }

    @Override
    public void updateUInt(long value) {
        byte[] encoded = new byte[4];
        BufferUtils.putUInt(value, encoded);
        this.update(encoded);
    }

    @Override
    public void doFinal(byte[] out, int offset) throws Exception {
        if (offset + 16 > NumberUtils.length(out)) {
            throw new BufferOverflowException();
        }
        if (this.currentBlockOffset > 0) {
            this.processBlock();
        }
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        this.h2 += this.h1 >>> 26;
        this.h1 &= 0x3FFFFFF;
        this.h3 += this.h2 >>> 26;
        this.h2 &= 0x3FFFFFF;
        this.h4 += this.h3 >>> 26;
        this.h3 &= 0x3FFFFFF;
        this.h0 += (this.h4 >>> 26) * 5;
        this.h4 &= 0x3FFFFFF;
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        int g0 = this.h0 + 5;
        int b = g0 >>> 26;
        g0 &= 0x3FFFFFF;
        int g1 = this.h1 + b;
        b = g1 >>> 26;
        g1 &= 0x3FFFFFF;
        int g2 = this.h2 + b;
        b = g2 >>> 26;
        g2 &= 0x3FFFFFF;
        int g3 = this.h3 + b;
        b = g3 >>> 26;
        g3 &= 0x3FFFFFF;
        int g4 = this.h4 + b - 0x4000000;
        b = (g4 >>> 31) - 1;
        int nb = ~b;
        this.h0 = this.h0 & nb | g0 & b;
        this.h1 = this.h1 & nb | g1 & b;
        this.h2 = this.h2 & nb | g2 & b;
        this.h3 = this.h3 & nb | g3 & b;
        this.h4 = this.h4 & nb | g4 & b;
        long f0 = Integer.toUnsignedLong(this.h0 | this.h1 << 26) + Integer.toUnsignedLong(this.k0);
        long f1 = Integer.toUnsignedLong(this.h1 >>> 6 | this.h2 << 20) + Integer.toUnsignedLong(this.k1);
        long f2 = Integer.toUnsignedLong(this.h2 >>> 12 | this.h3 << 14) + Integer.toUnsignedLong(this.k2);
        long f3 = Integer.toUnsignedLong(this.h3 >>> 18 | this.h4 << 8) + Integer.toUnsignedLong(this.k3);
        Poly1305Mac.packIntLE((int)f0, out, offset);
        Poly1305Mac.packIntLE((int)(f1 += f0 >>> 32), out, offset + 4);
        Poly1305Mac.packIntLE((int)(f2 += f1 >>> 32), out, offset + 8);
        Poly1305Mac.packIntLE((int)(f3 += f2 >>> 32), out, offset + 12);
        this.reset();
    }

    private void processBlock() {
        if (this.currentBlockOffset < 16) {
            this.currentBlock[this.currentBlockOffset] = 1;
            for (int i = this.currentBlockOffset + 1; i < 16; ++i) {
                this.currentBlock[i] = 0;
            }
        }
        long t0 = Integer.toUnsignedLong(Poly1305Mac.unpackIntLE(this.currentBlock, 0));
        long t1 = Integer.toUnsignedLong(Poly1305Mac.unpackIntLE(this.currentBlock, 4));
        long t2 = Integer.toUnsignedLong(Poly1305Mac.unpackIntLE(this.currentBlock, 8));
        long t3 = Integer.toUnsignedLong(Poly1305Mac.unpackIntLE(this.currentBlock, 12));
        this.h0 = (int)((long)this.h0 + (t0 & 0x3FFFFFFL));
        this.h1 = (int)((long)this.h1 + ((t1 << 32 | t0) >>> 26 & 0x3FFFFFFL));
        this.h2 = (int)((long)this.h2 + ((t2 << 32 | t1) >>> 20 & 0x3FFFFFFL));
        this.h3 = (int)((long)this.h3 + ((t3 << 32 | t2) >>> 14 & 0x3FFFFFFL));
        this.h4 = (int)((long)this.h4 + (t3 >>> 8));
        if (this.currentBlockOffset == 16) {
            this.h4 += 0x1000000;
        }
        long tp0 = Poly1305Mac.unsignedProduct(this.h0, this.r0) + Poly1305Mac.unsignedProduct(this.h1, this.s4) + Poly1305Mac.unsignedProduct(this.h2, this.s3) + Poly1305Mac.unsignedProduct(this.h3, this.s2) + Poly1305Mac.unsignedProduct(this.h4, this.s1);
        long tp1 = Poly1305Mac.unsignedProduct(this.h0, this.r1) + Poly1305Mac.unsignedProduct(this.h1, this.r0) + Poly1305Mac.unsignedProduct(this.h2, this.s4) + Poly1305Mac.unsignedProduct(this.h3, this.s3) + Poly1305Mac.unsignedProduct(this.h4, this.s2);
        long tp2 = Poly1305Mac.unsignedProduct(this.h0, this.r2) + Poly1305Mac.unsignedProduct(this.h1, this.r1) + Poly1305Mac.unsignedProduct(this.h2, this.r0) + Poly1305Mac.unsignedProduct(this.h3, this.s4) + Poly1305Mac.unsignedProduct(this.h4, this.s3);
        long tp3 = Poly1305Mac.unsignedProduct(this.h0, this.r3) + Poly1305Mac.unsignedProduct(this.h1, this.r2) + Poly1305Mac.unsignedProduct(this.h2, this.r1) + Poly1305Mac.unsignedProduct(this.h3, this.r0) + Poly1305Mac.unsignedProduct(this.h4, this.s4);
        long tp4 = Poly1305Mac.unsignedProduct(this.h0, this.r4) + Poly1305Mac.unsignedProduct(this.h1, this.r3) + Poly1305Mac.unsignedProduct(this.h2, this.r2) + Poly1305Mac.unsignedProduct(this.h3, this.r1) + Poly1305Mac.unsignedProduct(this.h4, this.r0);
        this.h0 = (int)tp0 & 0x3FFFFFF;
        this.h1 = (int)(tp1 += tp0 >>> 26) & 0x3FFFFFF;
        this.h2 = (int)(tp2 += tp1 >>> 26) & 0x3FFFFFF;
        this.h3 = (int)(tp3 += tp2 >>> 26) & 0x3FFFFFF;
        this.h4 = (int)(tp4 += tp3 >>> 26) & 0x3FFFFFF;
        this.h0 += (int)(tp4 >>> 26) * 5;
        this.h1 += this.h0 >>> 26;
        this.h0 &= 0x3FFFFFF;
        this.currentBlockOffset = 0;
    }

    private void reset() {
        this.h0 = 0;
        this.h1 = 0;
        this.h2 = 0;
        this.h3 = 0;
        this.h4 = 0;
        this.currentBlockOffset = 0;
        Arrays.fill(this.currentBlock, (byte)0);
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int getDefaultBlockSize() {
        return 16;
    }

    private static int unpackIntLE(byte[] buf, int off) {
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            ret |= Byte.toUnsignedInt(buf[off + i]) << i * 8;
        }
        return ret;
    }

    private static void packIntLE(int value, byte[] dst, int off) {
        for (int i = 0; i < 4; ++i) {
            dst[off + i] = (byte)(value >>> i * 8);
        }
    }

    private static long unsignedProduct(int i1, int i2) {
        return Integer.toUnsignedLong(i1) * Integer.toUnsignedLong(i2);
    }
}

