/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2;

import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.RuntimeSshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.AbstractIoServiceFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoAcceptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoConnector;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2.Nio2Acceptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2.Nio2Connector;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.CloseableExecutorService;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ThreadUtils;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.TimeUnit;

public class Nio2ServiceFactory
extends AbstractIoServiceFactory {
    private final AsynchronousChannelGroup group;
    private final CloseableExecutorService resuming;

    public Nio2ServiceFactory(FactoryManager factoryManager, CloseableExecutorService service, CloseableExecutorService resumeTasks) {
        super(factoryManager, ThreadUtils.newFixedThreadPoolIf(service, factoryManager.toString() + "-nio2", Nio2ServiceFactory.getNioWorkers(factoryManager)));
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(ThreadUtils.noClose(this.getExecutorService()));
            this.resuming = ThreadUtils.newFixedThreadPoolIf(resumeTasks, factoryManager.toString() + "-nio2-resume", Nio2ServiceFactory.getNioWorkers(factoryManager));
        }
        catch (IOException e) {
            this.warn("Failed ({}) to start async. channel group: {}", e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
    }

    @Override
    public IoConnector createConnector(IoHandler handler) {
        return this.autowireCreatedService(new Nio2Connector(this.getFactoryManager(), handler, this.group, this.resuming));
    }

    @Override
    public IoAcceptor createAcceptor(IoHandler handler) {
        return this.autowireCreatedService(new Nio2Acceptor(this.getFactoryManager(), handler, this.group, this.resuming));
    }

    @Override
    protected void doCloseImmediately() {
        try {
            if (!this.resuming.isShutdown()) {
                this.resuming.shutdownNow();
            }
            if (!this.group.isShutdown()) {
                this.log.debug("Shutdown group");
                this.group.shutdownNow();
                if (this.group.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.log.debug("Group successfully shut down");
                } else {
                    this.log.debug("Not all group tasks terminated");
                }
            }
        }
        catch (Exception e) {
            this.log.debug("Exception caught while closing channel group", e);
        }
        finally {
            super.doCloseImmediately();
        }
    }
}

