/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.session;

import io.jenkins.cli.shaded.org.apache.sshd.agent.common.AgentForwardSupport;
import io.jenkins.cli.shaded.org.apache.sshd.client.ClientFactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.AbstractClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSessionHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshConstants;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.GlobalRequestFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers.AbstractConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.core.CoreModuleProperties;
import io.jenkins.cli.shaded.org.apache.sshd.server.x11.X11ForwardSupport;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ClientConnectionService
extends AbstractConnectionService
implements ClientSessionHolder {
    protected final String heartbeatRequest = CoreModuleProperties.HEARTBEAT_REQUEST.getRequired(this);
    protected final Duration heartbeatInterval = CoreModuleProperties.HEARTBEAT_INTERVAL.getRequired(this);
    protected final Duration heartbeatReplyMaxWait = CoreModuleProperties.HEARTBEAT_REPLY_WAIT.getRequired(this);
    protected ScheduledFuture<?> clientHeartbeat;

    public ClientConnectionService(AbstractClientSession s) throws SshException {
        super(s);
    }

    @Override
    public final ClientSession getClientSession() {
        return this.getSession();
    }

    @Override
    public AbstractClientSession getSession() {
        return (AbstractClientSession)super.getSession();
    }

    @Override
    public void start() {
        ClientSession session = this.getClientSession();
        if (!session.isAuthenticated()) {
            throw new IllegalStateException("Session is not authenticated");
        }
        super.start();
    }

    @Override
    protected synchronized ScheduledFuture<?> startHeartBeat() {
        if (!GenericUtils.isNegativeOrNull(this.heartbeatInterval) && GenericUtils.isNotEmpty(this.heartbeatRequest)) {
            this.stopHeartBeat();
            ClientSession session = this.getClientSession();
            ClientFactoryManager manager = session.getFactoryManager();
            ScheduledExecutorService service = manager.getScheduledExecutorService();
            this.clientHeartbeat = service.scheduleAtFixedRate(this::sendHeartBeat, this.heartbeatInterval.toMillis(), this.heartbeatInterval.toMillis(), TimeUnit.MILLISECONDS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startHeartbeat({}) - started at interval={} with request={}", session, this.heartbeatInterval, this.heartbeatRequest);
            }
            return this.clientHeartbeat;
        }
        return super.startHeartBeat();
    }

    @Override
    protected synchronized void stopHeartBeat() {
        try {
            super.stopHeartBeat();
        }
        finally {
            if (this.clientHeartbeat != null) {
                this.clientHeartbeat = null;
            }
        }
    }

    @Override
    protected boolean sendHeartBeat() {
        if (this.clientHeartbeat == null) {
            return super.sendHeartBeat();
        }
        AbstractClientSession session = this.getSession();
        try {
            boolean withReply = !GenericUtils.isNegativeOrNull(this.heartbeatReplyMaxWait);
            Buffer buf = session.createBuffer((byte)80, this.heartbeatRequest.length() + 8);
            buf.putString(this.heartbeatRequest);
            buf.putBoolean(withReply);
            if (withReply) {
                long toWait;
                Instant start = Instant.now();
                CountDownLatch replyReceived = new CountDownLatch(1);
                GlobalRequestFuture writeFuture = session.request(buf, this.heartbeatRequest, (cmd, reply) -> {
                    replyReceived.countDown();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("sendHeartBeat({}) received reply={} size={} for request={}", session, SshConstants.getCommandMessageName(cmd), reply.available(), this.heartbeatRequest);
                    }
                });
                writeFuture.await(this.heartbeatReplyMaxWait);
                Throwable t = writeFuture.getException();
                if (t != null) {
                    throw new IOException(t.getMessage(), t);
                }
                Duration elapsed = Duration.between(start, Instant.now());
                if (elapsed.compareTo(this.heartbeatReplyMaxWait) < 0 && (toWait = this.heartbeatReplyMaxWait.minus(elapsed).toMillis()) > 0L) {
                    try {
                        replyReceived.await(toWait, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("sendHeartBeat({}) interrupted waiting for reply to request={}", (Object)session, (Object)this.heartbeatRequest);
                        }
                    }
                }
            } else {
                IoWriteFuture future = session.writePacket(buf);
                future.addListener(x$0 -> this.futureDone((IoWriteFuture)x$0));
            }
            this.heartbeatCount.incrementAndGet();
            return true;
        }
        catch (IOException | Error | RuntimeException e) {
            session.exceptionCaught(e);
            this.warn("sendHeartBeat({}) failed ({}) to send heartbeat #{} request={}: {}", session, e.getClass().getSimpleName(), this.heartbeatCount, this.heartbeatRequest, e.getMessage(), e);
            return false;
        }
    }

    @Override
    public AgentForwardSupport getAgentForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }

    @Override
    public X11ForwardSupport getX11ForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }
}

