/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.OptionalFeature;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoServiceFactoryFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ReflectionUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum BuiltinIoServiceFactoryFactories implements NamedFactory<IoServiceFactoryFactory>,
OptionalFeature
{
    NIO2(Nio2ServiceFactoryFactory.class),
    MINA("io.jenkins.cli.shaded.org.apache.sshd.common.io.mina.MinaServiceFactoryFactory"),
    NETTY("io.jenkins.cli.shaded.org.apache.sshd.netty.NettyIoServiceFactoryFactory");

    public static final Set<BuiltinIoServiceFactoryFactories> VALUES;
    private final Class<? extends IoServiceFactoryFactory> factoryClass;
    private final String factoryClassName;

    private BuiltinIoServiceFactoryFactories(Class<? extends IoServiceFactoryFactory> clazz) {
        this.factoryClass = clazz;
        this.factoryClassName = null;
    }

    private BuiltinIoServiceFactoryFactories(String clazz) {
        this.factoryClass = null;
        this.factoryClassName = clazz;
    }

    public final String getFactoryClassName() {
        if (this.factoryClass != null) {
            return this.factoryClass.getName();
        }
        return this.factoryClassName;
    }

    public final Class<? extends IoServiceFactoryFactory> getFactoryClass() {
        if (this.factoryClass != null) {
            return this.factoryClass;
        }
        try {
            return Class.forName(this.factoryClassName, true, BuiltinIoServiceFactoryFactories.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(this.factoryClassName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public final String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public final IoServiceFactoryFactory create() {
        Class<? extends IoServiceFactoryFactory> clazz = this.getFactoryClass();
        try {
            return ReflectionUtils.newInstance(clazz, IoServiceFactoryFactory.class);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isSupported() {
        try {
            return this.getFactoryClass() != null;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static BuiltinIoServiceFactoryFactories fromFactoryName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinIoServiceFactoryFactories fromFactoryClass(Class<?> clazz) {
        if (clazz == null || !IoServiceFactoryFactory.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (BuiltinIoServiceFactoryFactories f : VALUES) {
            if (!f.isSupported() || !clazz.isAssignableFrom(f.getFactoryClass())) continue;
            return f;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinIoServiceFactoryFactories.class));
    }
}

