/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.parser;

import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.parser.AbstractKexExtensionParser;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.parser.DelayedCompressionAlgorithms;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import java.io.IOException;

public class DelayCompression
extends AbstractKexExtensionParser<DelayedCompressionAlgorithms> {
    public static final String NAME = "delay-compression";
    public static final DelayCompression INSTANCE = new DelayCompression();

    public DelayCompression() {
        super(NAME);
    }

    @Override
    public DelayedCompressionAlgorithms parseExtension(Buffer buffer) throws IOException {
        DelayedCompressionAlgorithms algos = new DelayedCompressionAlgorithms();
        algos.setClient2Server(buffer.getNameList());
        algos.setServer2Client(buffer.getNameList());
        return algos;
    }

    @Override
    protected void encode(DelayedCompressionAlgorithms algos, Buffer buffer) throws IOException {
        int lenPos = buffer.wpos();
        buffer.putUInt(0L);
        buffer.putNameList(algos.getClient2Server());
        buffer.putNameList(algos.getServer2Client());
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }
}

