/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.channel;

import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Channel;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Window;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.WindowClosedException;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Predicate;

public class RemoteWindow
extends Window {
    private static final Predicate<Window> SPACE_AVAILABLE_PREDICATE = Window.largerThan(0L);

    public RemoteWindow(Channel channel, boolean isClient) {
        super(channel, isClient);
    }

    @Override
    public void init(long size, long packetSize, PropertyResolver resolver) {
        super.init(size, packetSize, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(long len) {
        long remainLen;
        BufferUtils.validateUint32Value(len, "Invalid consumption length: %d");
        this.checkInitialized("consume");
        Object object = this.lock;
        synchronized (object) {
            remainLen = this.getSize() - len;
            if (remainLen >= 0L) {
                this.updateSize(remainLen);
            }
        }
        if (remainLen < 0L) {
            throw new IllegalStateException("consume(" + this + ") required length (" + len + ") above available: " + (remainLen + len));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Consume {} by {} down to {}", this, len, remainLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(long increment) {
        long expandedSize;
        long initialSize;
        BufferUtils.validateUint32Value(increment, "Invalid window expansion size: %d");
        this.checkInitialized("expand");
        Object object = this.lock;
        synchronized (object) {
            initialSize = this.getSize();
            expandedSize = Math.min(initialSize + increment, 0xFFFFFFFFL);
            this.updateSize(expandedSize);
        }
        if (expandedSize - initialSize != increment) {
            this.log.warn("expand({}) window increase from {} by {} too large, set to {}", this, initialSize, increment, expandedSize);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("expand({}) increase window from {} by {} up to {}", this, initialSize, increment, expandedSize);
        }
    }

    public void waitAndConsume(long len, long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        this.waitAndConsume(len, Duration.ofMillis(maxWaitTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndConsume(long len, Duration maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        BufferUtils.validateUint32Value(len, "Invalid wait consume length: %d", (Object)len);
        this.checkInitialized("waitAndConsume");
        if (len == 0L) {
            return;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(RemoteWindow.largerThan(len - 1L), maxWaitTime);
            if (debugEnabled) {
                this.log.debug("waitAndConsume({}) - requested={}, available={}", this, len, this.getSize());
            }
            this.consume(len);
        }
    }

    public long waitForSpace(long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        return this.waitForSpace(Duration.ofMillis(maxWaitTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForSpace(Duration maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        long available;
        this.checkInitialized("waitForSpace");
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(SPACE_AVAILABLE_PREDICATE, maxWaitTime);
            available = this.getSize();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("waitForSpace({}) available: {}", (Object)this, (Object)available);
        }
        return available;
    }

    protected void waitForCondition(Predicate<? super Window> predicate, Duration maxWaitTime) throws WindowClosedException, InterruptedException, SocketTimeoutException {
        Objects.requireNonNull(predicate, "No condition");
        ValidateUtils.checkTrue(GenericUtils.isPositive(maxWaitTime), "Non-positive max. wait time: %s", (Object)maxWaitTime.toString());
        Instant cur = Instant.now();
        Instant waitEnd = cur.plus(maxWaitTime);
        while (this.isOpen() && cur.compareTo(waitEnd) < 0) {
            if (predicate.test(this)) {
                return;
            }
            Duration rem = Duration.between(cur, waitEnd);
            this.lock.wait(rem.toMillis(), rem.getNano() % 1000000);
            cur = Instant.now();
        }
        if (!this.isOpen()) {
            throw new WindowClosedException(this.toString());
        }
        throw new SocketTimeoutException("waitForCondition(" + this + ") timeout exceeded: " + maxWaitTime);
    }
}

