/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.cli.HexDump;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.StringWriter;

class DiagnosedStreamCorruptionException
extends StreamCorruptedException {
    private final Exception diagnoseFailure;
    private final byte[] readBack;
    private final byte[] readAhead;

    DiagnosedStreamCorruptionException(Exception cause, Exception diagnoseFailure, byte[] readBack, byte[] readAhead) {
        this.initCause(cause);
        this.diagnoseFailure = diagnoseFailure;
        this.readBack = readBack;
        this.readAhead = readAhead;
    }

    public Exception getDiagnoseFailure() {
        return this.diagnoseFailure;
    }

    public byte[] getReadBack() {
        return this.readBack;
    }

    public byte[] getReadAhead() {
        return this.readAhead;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString()).append("\n");
        buf.append("Read back: ").append(HexDump.toHex(this.readBack)).append('\n');
        buf.append("Read ahead: ").append(HexDump.toHex(this.readAhead));
        if (this.diagnoseFailure != null) {
            StringWriter w = new StringWriter();
            PrintWriter p = new PrintWriter(w);
            this.diagnoseFailure.printStackTrace(p);
            p.flush();
            buf.append("\nDiagnosis problem:\n    ");
            buf.append(w.toString().trim().replace("\n", "\n    "));
        }
        return buf.toString();
    }
}

