/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.keyprovider;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;

public class SimpleGeneratorHostKeyProvider
extends AbstractGeneratorHostKeyProvider {
    public SimpleGeneratorHostKeyProvider() {
    }

    public SimpleGeneratorHostKeyProvider(Path path) {
        this.setPath(path);
    }

    @Override
    protected Iterable<KeyPair> doReadKeyPairs(SessionContext session, NamedResource resourceKey, InputStream inputStream) throws IOException, GeneralSecurityException {
        KeyPair kp;
        try (ObjectInputStream r = new ObjectInputStream(inputStream);){
            try {
                kp = (KeyPair)r.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new InvalidKeySpecException("Missing classes: " + e.getMessage(), e);
            }
        }
        return Collections.singletonList(kp);
    }

    @Override
    protected void doWriteKeyPair(NamedResource resourceKey, KeyPair kp, OutputStream outputStream) throws IOException, GeneralSecurityException {
        try (ObjectOutputStream w = new ObjectOutputStream(outputStream);){
            w.writeObject(kp);
        }
    }
}

