/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.command;

import io.jenkins.cli.shaded.org.apache.sshd.common.file.FileSystemAware;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.CloseableExecutorService;
import io.jenkins.cli.shaded.org.apache.sshd.server.channel.ChannelSession;
import io.jenkins.cli.shaded.org.apache.sshd.server.command.AbstractCommandSupport;
import java.io.IOException;
import java.nio.file.FileSystem;

public abstract class AbstractFileSystemCommand
extends AbstractCommandSupport
implements FileSystemAware {
    protected FileSystem fileSystem;

    public AbstractFileSystemCommand(String command, CloseableExecutorService executorService) {
        super(command, executorService);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void destroy(ChannelSession channel) throws Exception {
        try {
            super.destroy(channel);
            if (this.fileSystem == null) return;
        }
        catch (Throwable throwable) {
            if (this.fileSystem == null) throw throwable;
            try {
                this.fileSystem.close();
                throw throwable;
            }
            catch (IOException | UnsupportedOperationException e) {
                if (!this.log.isDebugEnabled()) throw throwable;
                this.log.debug("destroy({}) - failed ({}) to close file system={}: {}", this, e.getClass().getSimpleName(), this.fileSystem, e.getMessage());
                throw throwable;
            }
            finally {
                this.fileSystem = null;
            }
        }
        try {
            this.fileSystem.close();
            return;
        }
        catch (IOException | UnsupportedOperationException e) {
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("destroy({}) - failed ({}) to close file system={}: {}", this, e.getClass().getSimpleName(), this.fileSystem, e.getMessage());
            return;
        }
        finally {
            this.fileSystem = null;
        }
    }
}

