/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.session;

import io.jenkins.cli.shaded.org.apache.sshd.client.ClientFactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.UserAuthFactory;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.keyboard.UserInteraction;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ChannelDirectTcpip;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ChannelExec;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ChannelShell;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ChannelSubsystem;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.ClientChannel;
import io.jenkins.cli.shaded.org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientProxyConnector;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSessionCreator;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientUserAuthService;
import io.jenkins.cli.shaded.org.apache.sshd.common.AttributeRepository;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.RuntimeSshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.BuiltinCiphers;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.CipherNone;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.OpenSshCertificate;
import io.jenkins.cli.shaded.org.apache.sshd.common.forward.Forwarder;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.KeyExchangeFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KexProposalOption;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KexState;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.KexExtensionHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionDisconnectHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers.AbstractConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers.AbstractSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ExceptionUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.net.SshdSocketAddress;
import io.jenkins.cli.shaded.org.apache.sshd.core.CoreModuleProperties;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractClientSession
extends AbstractSession
implements ClientSession {
    protected final boolean sendImmediateClientIdentification;
    protected final boolean sendImmediateKexInit;
    private final List<Object> identities = new CopyOnWriteArrayList<Object>();
    private final AuthenticationIdentitiesProvider identitiesProvider;
    private final AttributeRepository connectionContext;
    private PublicKey serverKey;
    private ServerKeyVerifier serverKeyVerifier;
    private UserInteraction userInteraction;
    private PasswordIdentityProvider passwordIdentityProvider;
    private PasswordAuthenticationReporter passwordAuthenticationReporter;
    private KeyIdentityProvider keyIdentityProvider;
    private PublicKeyAuthenticationReporter publicKeyAuthenticationReporter;
    private HostBasedAuthenticationReporter hostBasedAuthenticationReporter;
    private List<UserAuthFactory> userAuthFactories;
    private SocketAddress connectAddress;
    private ClientProxyConnector proxyConnector;

    protected AbstractClientSession(ClientFactoryManager factoryManager, IoSession ioSession) {
        super(false, factoryManager, ioSession);
        this.sendImmediateClientIdentification = CoreModuleProperties.SEND_IMMEDIATE_IDENTIFICATION.getRequired(this);
        this.sendImmediateKexInit = CoreModuleProperties.SEND_IMMEDIATE_KEXINIT.getRequired(this);
        this.identitiesProvider = AuthenticationIdentitiesProvider.wrapIdentities(this.identities);
        this.connectionContext = (AttributeRepository)ioSession.getAttribute(AttributeRepository.class);
    }

    @Override
    public AttributeRepository getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public ClientFactoryManager getFactoryManager() {
        return (ClientFactoryManager)super.getFactoryManager();
    }

    @Override
    public SocketAddress getConnectAddress() {
        return this.resolvePeerAddress(this.connectAddress);
    }

    public void setConnectAddress(SocketAddress connectAddress) {
        this.connectAddress = connectAddress;
    }

    @Override
    public PublicKey getServerKey() {
        return this.serverKey;
    }

    public void setServerKey(PublicKey serverKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setServerKey({}) keyType={}, digest={}", this, KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey));
        }
        this.serverKey = serverKey;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(ServerKeyVerifier.class, this.serverKeyVerifier, manager.getServerKeyVerifier());
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = serverKeyVerifier;
    }

    @Override
    public UserInteraction getUserInteraction() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(UserInteraction.class, this.userInteraction, manager.getUserInteraction());
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public PasswordAuthenticationReporter getPasswordAuthenticationReporter() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(PasswordAuthenticationReporter.class, this.passwordAuthenticationReporter, manager.getPasswordAuthenticationReporter());
    }

    @Override
    public void setPasswordAuthenticationReporter(PasswordAuthenticationReporter reporter) {
        this.passwordAuthenticationReporter = reporter;
    }

    @Override
    public List<UserAuthFactory> getUserAuthFactories() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveFactories(this.userAuthFactories, manager.getUserAuthFactories());
    }

    @Override
    public void setUserAuthFactories(List<UserAuthFactory> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(PasswordIdentityProvider.class, this.passwordIdentityProvider, manager.getPasswordIdentityProvider());
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider provider) {
        this.passwordIdentityProvider = provider;
    }

    @Override
    public KeyIdentityProvider getKeyIdentityProvider() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(KeyIdentityProvider.class, this.keyIdentityProvider, manager.getKeyIdentityProvider());
    }

    @Override
    public void setKeyIdentityProvider(KeyIdentityProvider keyIdentityProvider) {
        this.keyIdentityProvider = keyIdentityProvider;
    }

    @Override
    public PublicKeyAuthenticationReporter getPublicKeyAuthenticationReporter() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(PublicKeyAuthenticationReporter.class, this.publicKeyAuthenticationReporter, manager.getPublicKeyAuthenticationReporter());
    }

    @Override
    public void setPublicKeyAuthenticationReporter(PublicKeyAuthenticationReporter reporter) {
        this.publicKeyAuthenticationReporter = reporter;
    }

    @Override
    public HostBasedAuthenticationReporter getHostBasedAuthenticationReporter() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(HostBasedAuthenticationReporter.class, this.hostBasedAuthenticationReporter, manager.getHostBasedAuthenticationReporter());
    }

    @Override
    public void setHostBasedAuthenticationReporter(HostBasedAuthenticationReporter reporter) {
        this.hostBasedAuthenticationReporter = reporter;
    }

    @Override
    public ClientProxyConnector getClientProxyConnector() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(ClientProxyConnector.class, this.proxyConnector, manager.getClientProxyConnector());
    }

    @Override
    public void setClientProxyConnector(ClientProxyConnector proxyConnector) {
        this.proxyConnector = proxyConnector;
    }

    @Override
    public void addPasswordIdentity(String password) {
        ValidateUtils.checkTrue(password != null && !password.isEmpty(), "No password provided");
        this.identities.add(password);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(password));
        }
    }

    @Override
    public String removePasswordIdentity(String password) {
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.PASSWORD_IDENTITY_COMPARATOR, password);
        if (index >= 0) {
            return (String)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair kp) {
        Objects.requireNonNull(kp, "No key-pair to add");
        Objects.requireNonNull(kp.getPublic(), "No public key");
        Objects.requireNonNull(kp.getPrivate(), "No private key");
        this.identities.add(kp);
        if (this.log.isDebugEnabled()) {
            PublicKey key = kp.getPublic();
            this.log.debug("addPublicKeyIdentity({}) {}-{}", this, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.KEYPAIR_IDENTITY_COMPARATOR, kp);
        if (index >= 0) {
            return (KeyPair)this.identities.remove(index);
        }
        return null;
    }

    protected void initializeKeyExchangePhase() throws Exception {
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        if (extHandler == null || !extHandler.isKexExtensionsAvailable(this, KexExtensionHandler.AvailabilityPhase.PREKEX)) {
            this.kexState.set(KexState.INIT);
            this.sendKexInit();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("initializeKexPhase({}) delay KEX-INIT until server-side one received", (Object)this);
        }
    }

    protected void initializeProxyConnector() throws Exception {
        ClientProxyConnector proxyConnector = this.getClientProxyConnector();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (proxyConnector == null) {
            if (debugEnabled) {
                this.log.debug("initializeProxyConnector({}) no proxy to initialize", (Object)this);
            }
            return;
        }
        try {
            if (debugEnabled) {
                this.log.debug("initializeProxyConnector({}) initialize proxy={}", (Object)this, (Object)proxyConnector);
            }
            proxyConnector.sendClientProxyMetadata(this);
            if (debugEnabled) {
                this.log.debug("initializeProxyConnector({}) proxy={} initialized", (Object)this, (Object)proxyConnector);
            }
        }
        catch (Throwable t) {
            this.warn("initializeProxyConnector({}) failed ({}) to send proxy metadata: {}", this, t.getClass().getSimpleName(), t.getMessage(), t);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeSshException(t);
        }
    }

    protected IoWriteFuture sendClientIdentification() throws Exception {
        this.clientVersion = this.resolveIdentificationString(CoreModuleProperties.CLIENT_IDENTIFICATION.getName());
        this.signalSendIdentification(this.clientVersion, Collections.emptyList());
        return this.sendIdentification(this.clientVersion, Collections.emptyList());
    }

    @Override
    public ClientChannel createChannel(String type) throws IOException {
        return this.createChannel(type, null);
    }

    @Override
    public ClientChannel createChannel(String type, String subType) throws IOException {
        if ("shell".equals(type)) {
            return this.createShellChannel();
        }
        if ("exec".equals(type)) {
            return this.createExecChannel(subType);
        }
        if ("subsystem".equals(type)) {
            return this.createSubsystemChannel(subType);
        }
        throw new IllegalArgumentException("Unsupported channel type requested: " + type);
    }

    @Override
    public ChannelExec createExecChannel(String command, PtyChannelConfigurationHolder ptyConfig, Map<String, ?> env) throws IOException {
        ChannelExec channel = new ChannelExec(command, ptyConfig, env);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createExecChannel({})[{}] created id={} - PTY={}", this, command, id, ptyConfig);
        }
        return channel;
    }

    @Override
    public ChannelSubsystem createSubsystemChannel(String subsystem) throws IOException {
        ChannelSubsystem channel = new ChannelSubsystem(subsystem);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createSubsystemChannel({})[{}] created id={}", this, subsystem, id);
        }
        return channel;
    }

    @Override
    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        ChannelDirectTcpip channel = new ChannelDirectTcpip(local, remote);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createDirectTcpipChannel({})[{} => {}] created id={}", this, local, remote, id);
        }
        return channel;
    }

    protected ClientUserAuthService getUserAuthService() {
        return this.getService(ClientUserAuthService.class);
    }

    @Override
    protected ConnectionService getConnectionService() {
        return this.getService(ConnectionService.class);
    }

    @Override
    public SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        Forwarder forwarder = this.getForwarder();
        return forwarder.startLocalPortForwarding(local, remote);
    }

    @Override
    public void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        Forwarder forwarder = this.getForwarder();
        forwarder.stopLocalPortForwarding(local);
    }

    @Override
    public SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        Forwarder forwarder = this.getForwarder();
        return forwarder.startRemotePortForwarding(remote, local);
    }

    @Override
    public void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        Forwarder forwarder = this.getForwarder();
        forwarder.stopRemotePortForwarding(remote);
    }

    @Override
    public SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        Forwarder forwarder = this.getForwarder();
        return forwarder.startDynamicPortForwarding(local);
    }

    @Override
    public void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        Forwarder forwarder = this.getForwarder();
        forwarder.stopDynamicPortForwarding(local);
    }

    @Override
    protected Forwarder getForwarder() {
        ConnectionService service = Objects.requireNonNull(this.getConnectionService(), "No connection service");
        return Objects.requireNonNull(service.getForwarder(), "No forwarder");
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager manager) {
        ValidateUtils.checkTrue(manager == this.getFactoryManager(), "Mismatched factory manager instances");
        return NamedResource.getNames(this.getSignatureFactories());
    }

    @Override
    public void startService(String name, Buffer buffer) throws Exception {
        SessionDisconnectHandler handler = this.getSessionDisconnectHandler();
        if (handler != null && handler.handleUnsupportedServiceDisconnectReason(this, 5, name, buffer)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("startService({}) ignore unknown service={} by handler", (Object)this, (Object)name);
            }
            return;
        }
        throw new IllegalStateException("Starting services is not supported on the client side: " + name);
    }

    @Override
    public ChannelShell createShellChannel(PtyChannelConfigurationHolder ptyConfig, Map<String, ?> env) throws IOException {
        if (this.inCipher instanceof CipherNone || this.outCipher instanceof CipherNone) {
            throw new IllegalStateException("Interactive channels are not supported with none cipher");
        }
        ChannelShell channel = new ChannelShell(ptyConfig, env);
        ConnectionService service = this.getConnectionService();
        int id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createShellChannel({}) created id={} - PTY={}", this, id, ptyConfig);
        }
        return channel;
    }

    @Override
    protected boolean readIdentification(Buffer buffer) throws Exception {
        List<String> ident = this.doReadIdentification(buffer, false);
        int numLines = GenericUtils.size(ident);
        String string = this.serverVersion = numLines <= 0 ? null : ident.remove(numLines - 1);
        if (this.serverVersion == null) {
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("readIdentification({}) Server version string: {}", (Object)this, (Object)this.serverVersion);
        }
        if (!SessionContext.isValidVersionPrefix(this.serverVersion)) {
            throw new SshException(8, "Unsupported protocol version: " + this.serverVersion);
        }
        this.signalExtraServerVersionInfo(this.serverVersion, ident);
        if (!this.sendImmediateClientIdentification) {
            this.sendClientIdentification();
            this.initializeKeyExchangePhase();
        } else if (!this.sendImmediateKexInit) {
            this.initializeKeyExchangePhase();
        }
        return true;
    }

    protected void signalExtraServerVersionInfo(String version, List<String> lines) throws Exception {
        this.signalPeerIdentificationReceived(version, lines);
        if (GenericUtils.isEmpty(lines)) {
            return;
        }
        UserInteraction ui = this.getUserInteraction();
        try {
            if (ui != null && ui.isInteractionAllowed(this)) {
                ui.serverVersionInfo(this, lines);
            }
        }
        catch (Error e) {
            this.warn("signalExtraServerVersionInfo({})[{}] failed ({}) to consult interaction: {}", this, version, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
    }

    @Override
    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws Exception {
        this.mergeProposals(this.clientProposal, proposal);
        return super.sendKexInit(proposal);
    }

    @Override
    protected void setKexSeed(byte ... seed) {
        this.setClientKexData(seed);
    }

    @Override
    protected byte[] receiveKexInit(Buffer buffer) throws Exception {
        byte[] seed = super.receiveKexInit(buffer);
        if (this.kexState.compareAndSet(KexState.UNKNOWN, KexState.RUN)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("receiveKexInit({}) sending client proposal", (Object)this);
            }
            this.kexState.set(KexState.INIT);
            this.sendKexInit();
        }
        return seed;
    }

    @Override
    protected void receiveKexInit(Map<KexProposalOption, String> proposal, byte[] seed) throws IOException {
        this.mergeProposals(this.serverProposal, proposal);
        this.setServerKexData(seed);
    }

    @Override
    protected void checkKeys() throws IOException {
        ServerKeyVerifier serverKeyVerifier = Objects.requireNonNull(this.getServerKeyVerifier(), "No server key verifier");
        IoSession networkSession = this.getIoSession();
        SocketAddress remoteAddress = networkSession.getRemoteAddress();
        PublicKey serverKey = Objects.requireNonNull(this.getServerKey(), "No server key to verify");
        SshdSocketAddress targetServerAddress = this.getAttribute(ClientSessionCreator.TARGET_SERVER);
        if (targetServerAddress != null) {
            remoteAddress = targetServerAddress.toInetSocketAddress();
        }
        boolean verified = false;
        if (serverKey instanceof OpenSshCertificate) {
            verified = serverKeyVerifier.verifyServerKey(this, remoteAddress, ((OpenSshCertificate)serverKey).getCaPubKey());
            if (this.log.isDebugEnabled()) {
                this.log.debug("checkCA({}) key={}-{}, verified={}", this, KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey), verified);
            }
            if (!verified) {
                serverKey = ((OpenSshCertificate)serverKey).getCertPubKey();
            }
        }
        if (!verified) {
            verified = serverKeyVerifier.verifyServerKey(this, remoteAddress, serverKey);
            if (this.log.isDebugEnabled()) {
                this.log.debug("checkKeys({}) key={}-{}, verified={}", this, KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey), verified);
            }
        }
        if (!verified) {
            throw new SshException(9, "Server key did not validate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyExchangeFuture switchToNoneCipher() throws IOException {
        if (!(this.currentService instanceof AbstractConnectionService) || !GenericUtils.isEmpty(((AbstractConnectionService)this.currentService).getChannels())) {
            throw new IllegalStateException("The switch to the none cipher must be done immediately after authentication");
        }
        if (this.kexState.compareAndSet(KexState.DONE, KexState.INIT)) {
            String s2cEncClient;
            String c2sEncClient;
            String s2cEncServer;
            String c2sEncServer;
            DefaultKeyExchangeFuture kexFuture = new DefaultKeyExchangeFuture(this.toString(), null);
            DefaultKeyExchangeFuture prev = this.kexFutureHolder.getAndSet(kexFuture);
            if (prev != null) {
                DefaultKeyExchangeFuture defaultKeyExchangeFuture = prev;
                synchronized (defaultKeyExchangeFuture) {
                    Object value = prev.getValue();
                    if (value == null) {
                        prev.setValue(new SshException("Switch to none cipher while previous KEX is ongoing"));
                    }
                }
            }
            Map map = this.serverProposal;
            synchronized (map) {
                c2sEncServer = (String)this.serverProposal.get((Object)KexProposalOption.C2SENC);
                s2cEncServer = (String)this.serverProposal.get((Object)KexProposalOption.S2CENC);
            }
            boolean c2sEncServerNone = BuiltinCiphers.Constants.isNoneCipherIncluded(c2sEncServer);
            boolean s2cEncServerNone = BuiltinCiphers.Constants.isNoneCipherIncluded(s2cEncServer);
            Map map2 = this.clientProposal;
            synchronized (map2) {
                c2sEncClient = (String)this.clientProposal.get((Object)KexProposalOption.C2SENC);
                s2cEncClient = (String)this.clientProposal.get((Object)KexProposalOption.S2CENC);
            }
            boolean c2sEncClientNone = BuiltinCiphers.Constants.isNoneCipherIncluded(c2sEncClient);
            boolean s2cEncClientNone = BuiltinCiphers.Constants.isNoneCipherIncluded(s2cEncClient);
            if (!c2sEncServerNone || !s2cEncServerNone) {
                kexFuture.setValue(new SshException("Server does not support none cipher"));
            } else if (!c2sEncClientNone || !s2cEncClientNone) {
                kexFuture.setValue(new SshException("Client does not support none cipher"));
            } else {
                this.log.info("switchToNoneCipher({}) switching", (Object)this);
                EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
                Object object = this.clientProposal;
                synchronized (object) {
                    proposal.putAll(this.clientProposal);
                }
                proposal.put(KexProposalOption.C2SENC, "none");
                proposal.put(KexProposalOption.S2CENC, "none");
                object = this.kexState;
                synchronized (object) {
                    DefaultKeyExchangeFuture initFuture = this.kexInitializedFuture;
                    if (initFuture == null) {
                        this.kexInitializedFuture = initFuture = new DefaultKeyExchangeFuture(this.toString(), this.kexLock);
                    }
                    try {
                        byte[] seed = this.sendKexInit(proposal);
                        this.setKexSeed(seed);
                        initFuture.setValue(Boolean.TRUE);
                    }
                    catch (Exception e) {
                        initFuture.setValue(e);
                        ExceptionUtils.rethrowAsIoException(e);
                    }
                }
            }
            return (KeyExchangeFuture)Objects.requireNonNull(this.kexFutureHolder.get(), "No current KEX future");
        }
        throw new SshException("In flight key exchange");
    }
}

