/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.keys;

import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentityFileWatcher;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentityLoader;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentityLoaderHolder;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentityProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProviderHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.KeyPairProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClientIdentitiesWatcher
extends AbstractKeyPairProvider
implements KeyPairProvider {
    private final Collection<ClientIdentityProvider> providers;

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider) {
        this(paths, loader, provider, true);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(paths, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(loader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(provider, "No password provider")), strict);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider) {
        this(paths, loader, provider, true);
    }

    public ClientIdentitiesWatcher(Collection<? extends Path> paths, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider, boolean strict) {
        this(ClientIdentitiesWatcher.buildProviders(paths, loader, provider, strict));
    }

    public ClientIdentitiesWatcher(Collection<ClientIdentityProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Iterable<KeyPair> loadKeys(SessionContext session) {
        return this.loadKeys(session, null);
    }

    protected Iterable<KeyPair> loadKeys(SessionContext session, Predicate<? super KeyPair> filter) {
        return ClientIdentityProvider.lazyKeysLoader(this.providers, p -> this.doGetKeyPairs(session, (ClientIdentityProvider)p), filter);
    }

    protected Iterable<KeyPair> doGetKeyPairs(SessionContext session, ClientIdentityProvider p) {
        try {
            Iterable<KeyPair> kp = p.getClientIdentities(session);
            if (kp == null && this.log.isDebugEnabled()) {
                this.log.debug("loadKeys({}) no key loaded", (Object)p);
            }
            return kp;
        }
        catch (Throwable e) {
            this.warn("loadKeys({}) failed ({}) to load key: {}", p, e.getClass().getSimpleName(), e.getMessage(), e);
            return null;
        }
    }

    public static List<ClientIdentityProvider> buildProviders(Collection<? extends Path> paths, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        return ClientIdentitiesWatcher.buildProviders(paths, ClientIdentityLoaderHolder.loaderHolderOf(Objects.requireNonNull(loader, "No client identity loader")), FilePasswordProviderHolder.providerHolderOf(Objects.requireNonNull(provider, "No password provider")), strict);
    }

    public static List<ClientIdentityProvider> buildProviders(Collection<? extends Path> paths, ClientIdentityLoaderHolder loader, FilePasswordProviderHolder provider, boolean strict) {
        if (GenericUtils.isEmpty(paths)) {
            return Collections.emptyList();
        }
        return GenericUtils.map(paths, p -> new ClientIdentityFileWatcher((Path)p, loader, provider, strict));
    }
}

