/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.auth.hostbased;

import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@FunctionalInterface
public interface HostKeyIdentityProvider {
    public Iterable<? extends Map.Entry<KeyPair, List<X509Certificate>>> loadHostKeys(SessionContext var1) throws IOException, GeneralSecurityException;

    public static Iterator<? extends Map.Entry<KeyPair, List<X509Certificate>>> iteratorOf(SessionContext session, HostKeyIdentityProvider provider) throws IOException, GeneralSecurityException {
        return GenericUtils.iteratorOf(provider == null ? null : provider.loadHostKeys(session));
    }

    public static HostKeyIdentityProvider wrap(KeyPair ... pairs) {
        return HostKeyIdentityProvider.wrap(GenericUtils.asList(pairs));
    }

    public static HostKeyIdentityProvider wrap(Iterable<? extends KeyPair> pairs) {
        return session -> GenericUtils.wrapIterable(pairs, kp -> new AbstractMap.SimpleImmutableEntry((KeyPair)kp, Collections.emptyList()));
    }
}

