/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client;

import io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client.Filter;
import io.jenkins.cli.shaded.org.glassfish.tyrus.spi.CompletionHandler;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

class TaskQueueFilter
extends Filter {
    private final Queue<Task> taskQueue = new ConcurrentLinkedQueue<Task>();
    private final AtomicBoolean taskLock = new AtomicBoolean(false);

    TaskQueueFilter(Filter downstreamFilter) {
        super(downstreamFilter);
    }

    @Override
    void write(ByteBuffer data, CompletionHandler<ByteBuffer> completionHandler) {
        this.taskQueue.offer(new WriteTask(data, completionHandler));
        if (this.taskLock.compareAndSet(false, true)) {
            this.processTask();
        }
    }

    private void processTask() {
        Task task = this.taskQueue.poll();
        if (task == null) {
            this.taskLock.set(false);
            return;
        }
        task.execute(this);
    }

    @Override
    void close() {
        this.taskQueue.offer(new Task(){

            @Override
            public void execute(TaskQueueFilter queueFilter) {
                if (TaskQueueFilter.this.downstreamFilter != null) {
                    TaskQueueFilter.this.downstreamFilter.close();
                    TaskQueueFilter.this.upstreamFilter = null;
                }
                TaskQueueFilter.this.processTask();
            }
        });
        if (this.taskLock.compareAndSet(false, true)) {
            this.processTask();
        }
    }

    @Override
    void startSsl() {
        this.taskQueue.offer(new Task(){

            @Override
            public void execute(TaskQueueFilter queueFilter) {
                TaskQueueFilter.this.downstreamFilter.startSsl();
            }
        });
        if (this.taskLock.compareAndSet(false, true)) {
            this.processTask();
        }
    }

    @Override
    void processSslHandshakeCompleted() {
        this.processTask();
    }

    static class WriteTask
    implements Task {
        private final ByteBuffer data;
        private final CompletionHandler<ByteBuffer> completionHandler;

        WriteTask(ByteBuffer data, CompletionHandler<ByteBuffer> completionHandler) {
            this.data = data;
            this.completionHandler = completionHandler;
        }

        @Override
        public void execute(final TaskQueueFilter queueFilter) {
            queueFilter.downstreamFilter.write(this.getData(), new CompletionHandler<ByteBuffer>(){

                @Override
                public void failed(Throwable throwable) {
                    this.getCompletionHandler().failed(throwable);
                    queueFilter.processTask();
                }

                @Override
                public void completed(ByteBuffer result) {
                    if (result.hasRemaining()) {
                        this.execute(queueFilter);
                        return;
                    }
                    this.getCompletionHandler().completed(this.getData());
                    queueFilter.processTask();
                }
            });
        }

        ByteBuffer getData() {
            return this.data;
        }

        CompletionHandler<ByteBuffer> getCompletionHandler() {
            return this.completionHandler;
        }

        public String toString() {
            return "WriteTask{data=" + this.data + ", completionHandler=" + this.completionHandler + '}';
        }
    }

    static interface Task {
        public void execute(TaskQueueFilter var1);
    }
}

