/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.digest.Digest;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import javax.crypto.KeyAgreement;

public abstract class AbstractDH {
    protected KeyAgreement myKeyAgree;
    private byte[] k_array;
    private byte[] e_array;

    protected AbstractDH() {
    }

    public abstract void setF(byte[] var1);

    public boolean isPublicDataAvailable() {
        return this.e_array != null;
    }

    protected abstract byte[] calculateE() throws Exception;

    public byte[] getE() throws Exception {
        if (this.e_array == null) {
            this.e_array = this.calculateE();
            this.checkKeyAgreementNecessity();
        }
        return this.e_array;
    }

    public void putE(Buffer buffer, byte[] e) {
        buffer.putMPInt(e);
    }

    public void putF(Buffer buffer, byte[] f) {
        buffer.putMPInt(f);
    }

    public boolean isSharedSecretAvailable() {
        return this.k_array != null;
    }

    protected abstract byte[] calculateK() throws Exception;

    public byte[] getK() throws Exception {
        if (this.k_array == null) {
            this.k_array = this.calculateK();
            this.checkKeyAgreementNecessity();
        }
        return this.k_array;
    }

    protected void checkKeyAgreementNecessity() {
        if (this.e_array == null || this.k_array == null) {
            return;
        }
        if (this.myKeyAgree != null) {
            this.myKeyAgree = null;
        }
    }

    public abstract Digest getHash() throws Exception;

    public String toString() {
        return this.getClass().getSimpleName() + "[publicDataAvailable=" + this.isPublicDataAvailable() + ", sharedSecretAvailable=" + this.isSharedSecretAvailable() + "]";
    }

    public static byte[] stripLeadingZeroes(byte[] x) {
        int length = NumberUtils.length(x);
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 0) continue;
            if (i == 0) {
                return x;
            }
            byte[] ret = new byte[length - i];
            System.arraycopy(x, i, ret, 0, ret.length);
            return ret;
        }
        throw new IllegalArgumentException("No non-zero values in generated secret");
    }
}

