/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.global;

import io.jenkins.cli.shaded.org.apache.sshd.common.channel.RequestHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.forward.Forwarder;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers.AbstractConnectionServiceRequestHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.functors.Int2IntFunction;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.net.SshdSocketAddress;
import java.util.Objects;
import java.util.function.IntUnaryOperator;

public class CancelTcpipForwardHandler
extends AbstractConnectionServiceRequestHandler {
    public static final String REQUEST = "cancel-tcpip-forward";
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add(8);
    public static final CancelTcpipForwardHandler INSTANCE = new CancelTcpipForwardHandler();

    @Override
    public RequestHandler.Result process(ConnectionService connectionService, String request, boolean wantReply, Buffer buffer) throws Exception {
        if (!REQUEST.equals(request)) {
            return super.process(connectionService, request, wantReply, buffer);
        }
        String address = buffer.getString();
        int port = buffer.getInt();
        SshdSocketAddress socketAddress = new SshdSocketAddress(address, port);
        if (this.log.isDebugEnabled()) {
            this.log.debug("process({})[{}] {} reply={}", connectionService, request, socketAddress, wantReply);
        }
        Forwarder forwarder = Objects.requireNonNull(connectionService.getForwarder(), "No TCP/IP forwarder");
        forwarder.localPortForwardingCancelled(socketAddress);
        if (wantReply) {
            Object session = connectionService.getSession();
            buffer = session.createBuffer((byte)81, 4);
            buffer.putInt(port);
            session.writePacket(buffer);
        }
        return RequestHandler.Result.Replied;
    }
}

